/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.build.release.version;

public class Version {
    private final Integer major;
    private final Integer minor;
    private final Integer micro;
    private final String qualifier;

    public Version(Integer major, Integer minor, Integer micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public int getMajorOrZero() {
        return this.major != null ? this.major : 0;
    }

    public int getMinorOrZero() {
        return this.minor != null ? this.minor : 0;
    }

    public int getMicroOrZero() {
        return this.micro != null ? this.micro : 0;
    }

    public static Version parseVersion(String version) {
        boolean qualifier = false;
        StringBuilder sb = new StringBuilder();
        Integer major = null;
        Integer minor = null;
        Integer micro = null;
        int tok = 0;
        block19: for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (!qualifier) {
                switch (c) {
                    case '.': {
                        switch (tok) {
                            case 0: {
                                major = Version.toInteger(sb);
                                break;
                            }
                            case 1: {
                                minor = Version.toInteger(sb);
                                break;
                            }
                            case 2: {
                                micro = Version.toInteger(sb);
                            }
                        }
                        sb = new StringBuilder();
                        if (++tok < 3) continue block19;
                        qualifier = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        sb.append(c);
                        break;
                    }
                    default: {
                        switch (tok) {
                            case 0: {
                                major = Version.toInteger(sb);
                                break;
                            }
                            case 1: {
                                minor = Version.toInteger(sb);
                                break;
                            }
                            case 2: {
                                micro = Version.toInteger(sb);
                            }
                        }
                        ++tok;
                        sb = new StringBuilder();
                        if (c != '-') {
                            sb.append(c);
                        }
                        qualifier = true;
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        String qualifierString = null;
        if (qualifier) {
            if (sb.length() > 0) {
                qualifierString = sb.toString();
            }
        } else {
            switch (tok) {
                case 0: {
                    major = Version.toInteger(sb);
                    break;
                }
                case 1: {
                    minor = Version.toInteger(sb);
                    break;
                }
                case 2: {
                    micro = Version.toInteger(sb);
                }
            }
        }
        return new Version(major, minor, micro, qualifierString);
    }

    private static Integer toInteger(StringBuilder sb) {
        if (sb.length() <= 0) {
            return null;
        }
        return Integer.parseInt(sb.toString());
    }

    public boolean isSnapshot() {
        if (this.qualifier == null) {
            return false;
        }
        return this.qualifier.endsWith("SNAPSHOT");
    }
}

