/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.build.release.version;

import de.dentrassi.build.release.version.PhaseEvaluator;
import de.dentrassi.build.release.version.PhaseRule;
import de.dentrassi.build.release.version.Version;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="phase", defaultPhase=LifecyclePhase.VALIDATE, requiresProject=true, threadSafe=true)
public class ReleasePhaseMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.version}")
    private String version;
    @Parameter(defaultValue="releasePhase")
    private String prefix;
    @Parameter(defaultValue="1")
    private String defaultPhase;
    @Parameter(defaultValue="0")
    private String snapshotPhase;
    @Parameter
    private List<PhaseRule> rules = new LinkedList<PhaseRule>();

    public void setRules(List<PhaseRule> rules) {
        this.rules = rules;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSnapshotPhase(String snapshotPhase) {
        this.snapshotPhase = snapshotPhase;
    }

    public void setDefaultPhase(String defaultPhase) {
        this.defaultPhase = defaultPhase;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Version v = Version.parseVersion(this.version);
        PhaseEvaluator pe = new PhaseEvaluator();
        pe.setDefaultPhase(this.defaultPhase);
        pe.setSnapshotPhase(this.snapshotPhase);
        for (PhaseRule rule : this.rules) {
            pe.addRule(rule.getPhase(), Pattern.compile(rule.getPattern()), rule.getPriority());
        }
        String phase = pe.eval(v);
        this.setProperty("phase", phase);
    }

    private void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        String key = this.prefix != null && !this.prefix.isEmpty() ? this.prefix + "." + name : name;
        this.getLog().debug((CharSequence)String.format("Setting property '%s' = '%s'", key, value));
        this.project.getProperties().put(key, value);
    }
}

