/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.build.release.version;

import de.dentrassi.build.release.version.Version;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhaseEvaluator {
    private String snapshotPhase = "0";
    private String defaultPhase = "1";
    private int maxPriority = 0;
    private final List<Entry> entries = new LinkedList<Entry>();

    public void setSnapshotPhase(String snapshotPhase) {
        this.snapshotPhase = snapshotPhase;
    }

    public void setDefaultPhase(String defaultPhase) {
        this.defaultPhase = defaultPhase;
    }

    public void addRule(String phase, Pattern pattern) {
        this.addRule(phase, pattern, null);
    }

    public void addRule(String phase, Pattern pattern, Integer priority) {
        if (priority == null) {
            priority = this.maxPriority + 1;
        }
        this.maxPriority = Math.max(this.maxPriority, priority);
        this.entries.add(new Entry(priority, pattern, phase));
    }

    public String eval(Version version) {
        if (version.isSnapshot()) {
            return this.snapshotPhase;
        }
        String q = version.getQualifier();
        if (q == null) {
            return this.defaultPhase;
        }
        Collections.sort(this.entries);
        for (Entry entry : this.entries) {
            Matcher m = entry.pattern.matcher(q);
            if (!m.matches()) continue;
            return m.replaceAll(entry.phase);
        }
        return this.defaultPhase;
    }

    private static class Entry
    implements Comparable<Entry> {
        private final int priority;
        private final Pattern pattern;
        private final String phase;

        public Entry(int priority, Pattern pattern, String phase) {
            this.priority = priority;
            this.pattern = pattern;
            this.phase = phase;
        }

        @Override
        public int compareTo(Entry o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

