/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.internal.parser;

import de.dentrassi.asyncapi.ArrayType;
import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.CoreType;
import de.dentrassi.asyncapi.EnumType;
import de.dentrassi.asyncapi.Information;
import de.dentrassi.asyncapi.Message;
import de.dentrassi.asyncapi.MessageReference;
import de.dentrassi.asyncapi.ObjectType;
import de.dentrassi.asyncapi.Property;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.Type;
import de.dentrassi.asyncapi.TypeReference;
import de.dentrassi.asyncapi.internal.parser.Consume;
import de.dentrassi.asyncapi.internal.parser.ParserException;
import java.io.InputStream;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    private final Map<String, ?> document;
    private final Map<String, Message> messages = new HashMap<String, Message>();

    public YamlParser(InputStream in) throws ParserException {
        try {
            this.document = Consume.asMap(new Yaml().load(in));
        }
        catch (Exception e) {
            throw new ParserException("Failed to parse YAML document", e);
        }
    }

    public YamlParser(Reader reader) throws ParserException {
        try {
            this.document = Consume.asMap(new Yaml().load(reader));
        }
        catch (Exception e) {
            throw new ParserException("Failed to parse YAML document", e);
        }
    }

    public AsyncApi parse() {
        String version = Consume.asString("asyncapi", this.document);
        if (!"1.0.0".equals(version)) {
            throw new IllegalStateException(String.format("Only version '%s' is supported, this is version '%s'", "1.0.0", version));
        }
        AsyncApi api = new AsyncApi();
        api.setBaseTopic(Consume.asOptionalString("baseTopic", this.document).orElse(null));
        api.setHost(Consume.asString("host", this.document));
        api.setSchemes(Consume.asSet("schemes", this.document));
        api.setInformation(this.parseInfo(Consume.asMap("info", this.document)));
        api.setTopics(this.parseTopics(Consume.asMap("topics", this.document)));
        Map<String, ?> components = Consume.asMap("components", this.document);
        api.setMessages(this.parseMessages(Consume.asOptionalMap("messages", components).orElse(null)));
        api.setTypes(this.parseTypes(Consume.asOptionalMap("schemas", components).orElse(null)));
        return api;
    }

    private Set<Type> parseTypes(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Type> result = new LinkedHashSet<Type>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String name = entry.getKey();
            result.add(this.parseExplicitType("types", Collections.emptyList(), name, Consume.asMap(entry.getValue())));
        }
        return result;
    }

    private Set<Message> parseMessages(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Message> result = new LinkedHashSet<Message>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String name = entry.getKey();
            result.add(this.parseExplicitMessage(name, Consume.asMap(entry.getValue())));
        }
        return result;
    }

    private TypeReference parseType(String namespace, List<String> parents, String name, Map<String, ?> map) {
        Optional<String> ref = Consume.asOptionalString("$ref", map);
        if (ref.isPresent()) {
            Reference to = Reference.parse(ref.get());
            return new TypeReference(this.mapPackageName(to.last(1)), to.last());
        }
        return this.parseExplicitType(namespace, parents, name, map);
    }

    private String mapPackageName(String type) {
        if ("schemas".equals(type)) {
            return "types";
        }
        return type;
    }

    private Type parseExplicitType(String namespace, List<String> parents, String name, Map<String, ?> map) {
        String type;
        switch (type = Consume.asString("type", map)) {
            case "boolean": {
                return this.addCommonTypeInfo(new CoreType(name, Boolean.class), map);
            }
            case "integer": {
                return this.addCommonTypeInfo(new CoreType(name, Integer.class), map);
            }
            case "number": {
                return this.addCommonTypeInfo(new CoreType(name, Double.class), map);
            }
            case "string": {
                if (map.containsKey("enum")) {
                    return this.addCommonTypeInfo(this.parseEnumType(namespace, parents, name, map), map);
                }
                return this.addCommonTypeInfo(this.parseCoreType(name, map), map);
            }
            case "array": {
                return this.addCommonTypeInfo(this.parseArrayType(namespace, parents, name, map), map);
            }
            case "object": {
                return this.addCommonTypeInfo(this.parseObjectType(namespace, parents, name, map), map);
            }
        }
        throw new IllegalStateException(String.format("Unsupported type: %s", type));
    }

    private static List<String> push(List<String> parents, String name) {
        ArrayList<String> result = new ArrayList<String>(parents);
        result.add(name);
        return result;
    }

    private Type parseArrayType(String namespace, List<String> parents, String name, Map<String, ?> map) {
        boolean uniqueItems = Consume.asBoolean(map, "uniqueItems");
        TypeReference itemType = this.parseType(namespace, parents, name + "Item", Consume.asMap("items", map));
        ArrayType type = new ArrayType(name, itemType, uniqueItems);
        return type;
    }

    private Type parseEnumType(String namespace, List<String> parents, String name, Map<String, ?> map) {
        EnumType type = new EnumType(namespace, parents, name);
        type.setLiterals(Consume.asSet("enum", map));
        return type;
    }

    private CoreType parseCoreType(String name, Map<String, ?> map) {
        String format = Consume.asOptionalString("format", map).orElse(null);
        if (format == null) {
            return new CoreType(name, String.class);
        }
        switch (format) {
            case "date-time": {
                return new CoreType(name, ZonedDateTime.class);
            }
        }
        throw new IllegalStateException(String.format("Unknown data format: " + format, new Object[0]));
    }

    private Type parseObjectType(String namespace, List<String> parents, String name, Map<String, ?> map) {
        ObjectType type = new ObjectType(namespace, parents, name);
        Set required = Consume.asOptionalSet("required", map).orElse(Collections.emptySet());
        Map<String, ?> prop = Consume.asMap("properties", map);
        for (Map.Entry<String, ?> entry : prop.entrySet()) {
            Property p = new Property();
            String propName = entry.getKey();
            Map<String, ?> propValues = Consume.asMap(entry.getValue());
            p.setName(propName);
            p.setDescription(Consume.asOptionalString("description", propValues).orElse(null));
            p.setRequired(required.contains(propName));
            p.setType(this.parseType(namespace, YamlParser.push(parents, name), entry.getKey(), propValues));
            type.getProperties().add(p);
        }
        return type;
    }

    private Type addCommonTypeInfo(Type type, Map<String, ?> map) {
        type.setTitle(Consume.asOptionalString("title", map).orElse(null));
        type.setDescription(Consume.asOptionalString("description", map).orElse(null));
        return type;
    }

    private Set<Topic> parseTopics(Map<String, ?> topics) {
        HashSet<Topic> result = new HashSet<Topic>();
        for (Map.Entry<String, ?> entry : topics.entrySet()) {
            result.add(this.parseTopic(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Topic parseTopic(String key, Object value) {
        Map<String, ?> map = Consume.asMap(value);
        Topic result = new Topic();
        result.setName(key);
        result.setPublish(Consume.asOptionalMap("publish", map).map(v -> this.parseMessage("Publish. " + key, (Map<String, ?>)v)).orElse(null));
        result.setSubscribe(Consume.asOptionalMap("subscribe", map).map(v -> this.parseMessage("Subscribe." + key, (Map<String, ?>)v)).orElse(null));
        return result;
    }

    private MessageReference parseMessage(String name, Map<String, ?> map) {
        Optional<String> ref = Consume.asOptionalString("$ref", map);
        if (ref.isPresent()) {
            Reference to = Reference.parse(ref.get());
            String refName = to.last();
            return new MessageReference(refName);
        }
        return this.parseExplicitMessage(name, map);
    }

    private Message parseExplicitMessage(String name, Map<String, ?> map) {
        Message message = new Message(name);
        message.setDescription(Consume.asOptionalString("description", map).orElse(null));
        message.setSummary(Consume.asOptionalString("summary", map).orElse(null));
        message.setPayload(this.parseType("messages", Collections.singletonList(name), "payload", Consume.asMap("payload", map)));
        this.messages.put(name, message);
        return message;
    }

    private Information parseInfo(Map<String, ?> map) {
        Information result = new Information();
        result.setTitle(Consume.asOptionalString("title", map).orElse(null));
        result.setVersion(Consume.asString("version", map));
        return result;
    }

    private static class Reference
    implements Iterable<String> {
        private final List<String> tokens;

        public Reference(List<String> tokens) {
            this.tokens = tokens;
            if (tokens.isEmpty()) {
                throw new IllegalArgumentException("Reference must not be empty");
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.tokens.iterator();
        }

        public static Reference parse(String ref) {
            return new Reference(Arrays.asList(ref.split("/+")));
        }

        public String last() {
            return this.last(0);
        }

        public String last(int reverseIndex) {
            return this.tokens.get(this.tokens.size() - (reverseIndex + 1));
        }
    }
}

