/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi;

import de.dentrassi.asyncapi.AsyncApi;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Validator {
    private final List<Marker> markers = new LinkedList<Marker>();

    public void validate(AsyncApi api) {
        String baseTopic = api.getBaseTopic();
        if (baseTopic != null && !baseTopic.isEmpty() && !baseTopic.matches("^[^/.]")) {
            this.reportError("Base topic must match pattern: {0} - but is: {1}", "^[^/.]", baseTopic);
        }
    }

    protected void reportError(String message, Object ... arguments) {
        this.markers.add(new Marker(message, arguments));
    }

    public boolean hasErrors() {
        return !this.markers.isEmpty();
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public static class Marker {
        private final String message;
        private final List<Object> arguments;

        public Marker(String message, Object[] arguments) {
            this.message = message;
            this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
        }

        public String getMessage() {
            return this.message;
        }

        public List<Object> getArguments() {
            return this.arguments;
        }

        public String format() {
            return MessageFormat.format(this.message, this.arguments);
        }
    }
}

