/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi;

import de.dentrassi.asyncapi.Information;
import de.dentrassi.asyncapi.Message;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.Type;
import de.dentrassi.asyncapi.ValidationException;
import de.dentrassi.asyncapi.Validator;
import de.dentrassi.asyncapi.internal.parser.ParserException;
import de.dentrassi.asyncapi.internal.parser.YamlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AsyncApi {
    public static final String VERSION = "1.0.0";
    private Information information;
    private String baseTopic;
    private Set<String> schemes = new HashSet<String>();
    private String host;
    private Set<Topic> topics = new LinkedHashSet<Topic>();
    private Set<Message> messages = new LinkedHashSet<Message>();
    private Set<Type> types = new LinkedHashSet<Type>();

    public Set<Topic> getTopics() {
        return this.topics;
    }

    public void setTopics(Set<Topic> topics) {
        this.topics = topics;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBaseTopic() {
        return this.baseTopic;
    }

    public void setBaseTopic(String baseTopic) {
        this.baseTopic = baseTopic;
    }

    public Set<String> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(Set<String> schemes) {
        this.schemes = schemes;
    }

    public Information getInformation() {
        return this.information;
    }

    public void setInformation(Information info) {
        this.information = info;
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Set<Message> messages) {
        this.messages = messages;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public void setTypes(Set<Type> types) {
        this.types = types;
    }

    public static AsyncApi parseYaml(InputStream in) throws ParserException {
        return AsyncApi.validate(new YamlParser(in).parse());
    }

    public static AsyncApi parseYaml(Reader reader) throws ParserException {
        return AsyncApi.validate(new YamlParser(reader).parse());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AsyncApi parseYaml(Path path) throws ParserException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            AsyncApi asyncApi = AsyncApi.validate(new YamlParser(in).parse());
            return asyncApi;
        }
        catch (IOException e) {
            throw new ParserException("Failed to read file", e);
        }
    }

    public static AsyncApi validate(AsyncApi api) {
        Validator validator = new Validator();
        validator.validate(api);
        if (validator.hasErrors()) {
            throw new ValidationException(validator.getMarkers());
        }
        return api;
    }
}

