/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.internal.parser;

import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.EnumType;
import de.dentrassi.asyncapi.Information;
import de.dentrassi.asyncapi.Message;
import de.dentrassi.asyncapi.MessageReference;
import de.dentrassi.asyncapi.ObjectType;
import de.dentrassi.asyncapi.Property;
import de.dentrassi.asyncapi.StringType;
import de.dentrassi.asyncapi.Topic;
import de.dentrassi.asyncapi.Type;
import de.dentrassi.asyncapi.TypeReference;
import de.dentrassi.asyncapi.internal.parser.Consume;
import de.dentrassi.asyncapi.internal.parser.ParserException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    private final Map<String, ?> document;
    private final Map<String, Message> messages = new HashMap<String, Message>();

    public YamlParser(InputStream in) throws ParserException {
        try {
            this.document = Consume.asMap(new Yaml().load(in));
        }
        catch (Exception e) {
            throw new ParserException("Failed to parse YAML document", e);
        }
    }

    public YamlParser(Reader reader) throws ParserException {
        try {
            this.document = Consume.asMap(new Yaml().load(reader));
        }
        catch (Exception e) {
            throw new ParserException("Failed to parse YAML document", e);
        }
    }

    public AsyncApi parse() {
        String version = Consume.asString("asyncapi", this.document);
        if (!"1.0.0".equals(version)) {
            throw new IllegalStateException(String.format("Only version '%s' is supported, this is version '%s'", "1.0.0", version));
        }
        AsyncApi api = new AsyncApi();
        api.setBaseTopic(Consume.asString("baseTopic", this.document));
        api.setHost(Consume.asString("host", this.document));
        api.setSchemes(Consume.asSet("schemes", this.document));
        api.setInformation(this.parseInfo(Consume.asMap("info", this.document)));
        api.setTopics(this.parseTopics(Consume.asMap("topics", this.document)));
        Map<String, ?> components = Consume.asMap("components", this.document);
        api.setMessages(this.parseMessages(Consume.asOptionalMap("messages", components).orElse(null)));
        api.setTypes(this.parseTypes(Consume.asOptionalMap("schemas", components).orElse(null)));
        return api;
    }

    private Set<Type> parseTypes(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Type> result = new LinkedHashSet<Type>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String name = entry.getKey();
            result.add(this.parseExplicitType(name, Consume.asMap(entry.getValue())));
        }
        return result;
    }

    private Set<Message> parseMessages(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Message> result = new LinkedHashSet<Message>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String name = entry.getKey();
            result.add(this.parseExplicitMessage(name, Consume.asMap(entry.getValue())));
        }
        return result;
    }

    private TypeReference parseType(String name, Map<String, ?> map) {
        Optional<String> ref = Consume.asOptionalString("$ref", map);
        if (ref.isPresent()) {
            Reference to = Reference.parse(ref.get());
            return new TypeReference(to.last());
        }
        return this.parseExplicitType(name, map);
    }

    private Type parseExplicitType(String name, Map<String, ?> map) {
        String type;
        switch (type = Consume.asString("type", map)) {
            case "string": {
                if (map.containsKey("enum")) {
                    return this.addCommonTypeInfo(this.parseEnumType(name, map), map);
                }
                return this.addCommonTypeInfo(this.parseStringType(name, map), map);
            }
            case "object": {
                return this.addCommonTypeInfo(this.parseObjectType(name, map), map);
            }
        }
        throw new IllegalStateException(String.format("Unknown type: %s", type));
    }

    private Type parseEnumType(String name, Map<String, ?> map) {
        EnumType type = new EnumType(name);
        type.setLiterals(Consume.asSet("enum", map));
        return type;
    }

    private StringType parseStringType(String name, Map<String, ?> map) {
        StringType type = new StringType(name);
        type.setFormat(Consume.asOptionalString("format", map).orElse(null));
        return type;
    }

    private Type parseObjectType(String name, Map<String, ?> map) {
        ObjectType type = new ObjectType(name);
        Set required = Consume.asOptionalSet("required", map).orElse(Collections.emptySet());
        Map<String, ?> prop = Consume.asMap("properties", map);
        for (Map.Entry<String, ?> entry : prop.entrySet()) {
            Property p = new Property();
            String propName = entry.getKey();
            Map<String, ?> propValues = Consume.asMap(entry.getValue());
            p.setName(propName);
            p.setDescription(Consume.asOptionalString("description", propValues).orElse(null));
            p.setRequired(required.contains(propName));
            p.setType(this.parseType(entry.getKey(), propValues));
            type.getProperties().add(p);
        }
        return type;
    }

    private Type addCommonTypeInfo(Type type, Map<String, ?> map) {
        type.setTitle(Consume.asOptionalString("title", map).orElse(null));
        type.setDescription(Consume.asOptionalString("description", map).orElse(null));
        return type;
    }

    private Set<Topic> parseTopics(Map<String, ?> topics) {
        HashSet<Topic> result = new HashSet<Topic>();
        for (Map.Entry<String, ?> entry : topics.entrySet()) {
            result.add(this.parseTopic(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Topic parseTopic(String key, Object value) {
        Map<String, ?> map = Consume.asMap(value);
        Topic result = new Topic();
        result.setName(key);
        result.setPublish(Consume.asOptionalMap("publish", map).map(v -> this.parseMessage("Publish. " + key, (Map<String, ?>)v)).orElse(null));
        result.setSubscribe(Consume.asOptionalMap("subscribe", map).map(v -> this.parseMessage("Subscribe." + key, (Map<String, ?>)v)).orElse(null));
        return result;
    }

    private MessageReference parseMessage(String name, Map<String, ?> map) {
        Optional<String> ref = Consume.asOptionalString("$ref", map);
        if (ref.isPresent()) {
            Reference to = Reference.parse(ref.get());
            String refName = to.last();
            return new MessageReference(refName);
        }
        return this.parseExplicitMessage(name, map);
    }

    private Message parseExplicitMessage(String name, Map<String, ?> map) {
        Message message = new Message(name);
        message.setDescription(Consume.asOptionalString("description", map).orElse(null));
        message.setSummary(Consume.asOptionalString("summary", map).orElse(null));
        message.setPayload(this.parseType("payload", Consume.asMap("payload", map)));
        this.messages.put(name, message);
        return message;
    }

    private Information parseInfo(Map<String, ?> map) {
        Information result = new Information();
        result.setTitle(Consume.asOptionalString("title", map).orElse(null));
        result.setVersion(Consume.asString("version", map));
        return result;
    }

    private static class Reference
    implements Iterable<String> {
        private final List<String> tokens;

        public Reference(List<String> tokens) {
            this.tokens = tokens;
            if (tokens.isEmpty()) {
                throw new IllegalArgumentException("Reference must not be empty");
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.tokens.iterator();
        }

        public static Reference parse(String ref) {
            return new Reference(Arrays.asList(ref.split("/+")));
        }

        public String last() {
            return this.tokens.get(this.tokens.size() - 1);
        }
    }
}

