/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.internal.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Consume {
    private Consume() {
    }

    public static Map<String, ?> asMap(String key, Map<String, ?> map) {
        return Consume.required(key, Consume.asOptionalMap(key, map));
    }

    public static Optional<Map<String, ?>> asOptionalMap(String key, Map<String, ?> map) {
        Object result = map.get(key);
        if (result == null) {
            return Optional.empty();
        }
        if (result instanceof Map) {
            return Optional.of((Map)result);
        }
        throw Consume.wrongTypeError(key, Map.class, result);
    }

    public static Map<String, ?> asMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        throw Consume.wrongTypeError(null, Map.class, value);
    }

    public static Optional<String> asOptionalString(String key, Map<String, ?> map) {
        Object result = map.get(key);
        if (result == null) {
            return Optional.empty();
        }
        if (result instanceof String) {
            return Optional.ofNullable((String)result);
        }
        throw Consume.wrongTypeError(key, String.class, result);
    }

    public static String asString(String key, Map<String, ?> map) {
        return Consume.required(key, Consume.asOptionalString(key, map));
    }

    private static IllegalStateException wrongTypeError(String key, Class<?> expected, Object result) {
        return new IllegalStateException(String.format("Key '%s' is expected to be of type %s (but is %s instead)", key != null ? " '" + key + "'" : "", expected.getSimpleName(), result.getClass().getSimpleName()));
    }

    private static IllegalStateException keyMissingError(String key) {
        return new IllegalStateException(String.format("Key '%s' is missing in map", key));
    }

    private static <T> T required(String key, Optional<T> value) {
        return value.orElseThrow(() -> Consume.keyMissingError(key));
    }

    public static Set<String> asSet(String key, Map<String, ?> map) {
        return Consume.required(key, Consume.asOptionalSet(key, map));
    }

    public static Optional<Set<String>> asOptionalSet(String key, Map<String, ?> map) {
        Object value = map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            return Optional.of(new HashSet((Collection)value));
        }
        throw Consume.wrongTypeError(key, Collection.class, value);
    }
}

