/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.jms;

import de.dentrassi.asyncapi.Message;
import de.dentrassi.asyncapi.format.TextPayloadFormat;
import java.io.Serializable;
import java.util.Objects;
import javax.jms.Session;
import javax.jms.TextMessage;

public interface JmsPayloadFormat {
    public <M extends Message<P>, P extends Serializable> M decode(Class<M> var1, Class<P> var2, javax.jms.Message var3) throws Exception;

    public javax.jms.Message encode(Session var1, Message<?> var2) throws Exception;

    public static JmsPayloadFormat textMessageFormat(final TextPayloadFormat textPayloadFormat) {
        Objects.requireNonNull(textPayloadFormat);
        return new JmsPayloadFormat(){

            @Override
            public javax.jms.Message encode(Session session, Message<?> message) throws Exception {
                return session.createTextMessage(textPayloadFormat.encode(message));
            }

            @Override
            public <M extends Message<P>, P extends Serializable> M decode(Class<M> clazz, Class<P> payloadClazz, javax.jms.Message message) throws Exception {
                if (message instanceof TextMessage) {
                    return (M)textPayloadFormat.decode(clazz, payloadClazz, ((TextMessage)message).getText());
                }
                return null;
            }
        };
    }

    public static JmsPayloadFormat objectMessageFormat() {
        return new JmsPayloadFormat(){

            @Override
            public javax.jms.Message encode(Session session, Message<?> message) throws Exception {
                return session.createObjectMessage(message.getPayload());
            }

            @Override
            public <M extends Message<P>, P extends Serializable> M decode(Class<M> clazz, Class<P> payloadClazz, javax.jms.Message message) throws Exception {
                if (message.isBodyAssignableTo(payloadClazz)) {
                    Message m = (Message)clazz.newInstance();
                    m.setPayload((Serializable)message.getBody(payloadClazz));
                    return (M)m;
                }
                return null;
            }
        };
    }
}

