/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.jms;

import de.dentrassi.asyncapi.Connector;
import de.dentrassi.asyncapi.format.TextPayloadFormat;
import de.dentrassi.asyncapi.jms.JmsPayloadFormat;
import de.dentrassi.asyncapi.jms.JmsProfile;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class AbstractJmsConnector
implements Connector,
AutoCloseable {
    protected final Connection connection;
    protected final ExecutorService executor;

    protected AbstractJmsConnector(Builder<?> builder) throws JMSException {
        Objects.requireNonNull(builder.profile(), "JMS profile is not set");
        ConnectionFactory cf = builder.profile().connectionFactory().apply(builder);
        String username = builder.username();
        String password = builder.password();
        this.connection = username != null ? cf.createConnection(username, password) : cf.createConnection();
        this.connection.start();
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public void close() throws Exception {
        try {
            this.connection.close();
        }
        finally {
            this.executor.shutdown();
        }
    }

    public static abstract class Builder<C extends AbstractJmsConnector>
    extends Connector.AbstractBuilder<Builder<C>, C> {
        private JmsProfile profile;
        private JmsPayloadFormat payloadFormat = JmsPayloadFormat.objectMessageFormat();
        private String username;
        private String password;

        protected Builder() {
        }

        protected Builder<C> builder() {
            return this;
        }

        public Builder<C> profile(JmsProfile profile) {
            this.profile = profile;
            return this;
        }

        public JmsProfile profile() {
            return this.profile;
        }

        public Builder<C> payloadFormat(TextPayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat != null ? JmsPayloadFormat.textMessageFormat(payloadFormat) : null;
            return this;
        }

        public Builder<C> payloadFormat(JmsPayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        public JmsPayloadFormat payloadFormat() {
            return this.payloadFormat;
        }

        public Builder<C> username(String username) {
            this.username = username;
            return this;
        }

        public String username() {
            return this.username;
        }

        public Builder<C> password(String password) {
            this.password = password;
            return this;
        }

        public String password() {
            return this.password;
        }
    }
}

