/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.asyncapi.generator.java;

import de.dentrassi.asyncapi.ArrayType;
import de.dentrassi.asyncapi.CoreType;
import de.dentrassi.asyncapi.Type;
import de.dentrassi.asyncapi.TypeReference;
import de.dentrassi.asyncapi.generator.java.PropertyInformation;
import de.dentrassi.asyncapi.generator.java.TypeBuilder;
import de.dentrassi.asyncapi.generator.java.TypeInformation;
import de.dentrassi.asyncapi.generator.java.util.JDTHelper;
import de.dentrassi.asyncapi.generator.java.util.Names;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class PackageTypeBuilder
implements TypeBuilder {
    private static final String TYPE_NAME_LIST = "java.util.List";
    private static final String TYPE_NAME_SET = "java.util.Set";
    private final Charset charset;
    private final String packageName;
    private final Path rootPath;
    private final Function<Type, String> typeLookup;
    private final Function<TypeReference, Type> typeResolver;

    public PackageTypeBuilder(Path root, String packageName, Charset charset, Function<Type, String> typeLookup, Function<TypeReference, Type> typeResolver) {
        this.charset = charset;
        this.packageName = packageName;
        this.rootPath = root;
        this.typeLookup = typeLookup;
        this.typeResolver = typeResolver;
    }

    public static String asTypeName(String name) {
        return Names.toCamelCase(name, true);
    }

    private static String asConstantName(String name) {
        return Names.toUpperUnderscore(name);
    }

    public static String asPropertyName(String name) {
        return Names.toCamelCase(name, false);
    }

    private static String asMethodPropertyName(String prefix, String name) {
        return prefix + Names.toCamelCase(name, true);
    }

    protected void createNew(String name, BiConsumer<AST, CompilationUnit> consumer) {
        PackageTypeBuilder.createCompilationUnit(this.rootPath, this.packageName, name, this.charset, consumer);
    }

    public static void createCompilationUnit(Path rootPath, String packageName, String name, Charset charset, BiConsumer<AST, CompilationUnit> consumer) {
        AST ast = AST.newAST((int)8);
        CompilationUnit cu = ast.newCompilationUnit();
        PackageDeclaration pkg = ast.newPackageDeclaration();
        pkg.setName(ast.newName(packageName));
        cu.setPackage(pkg);
        Path path = rootPath.resolve(packageName.replace(".", File.separator)).resolve(name + ".java");
        consumer.accept(ast, cu);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
            String s = cu.toString();
            TextEdit result = formatter.format(8, s, 0, s.length(), 0, null);
            Document doc = new Document(s);
            result.apply((IDocument)doc);
            try (BufferedWriter writer = Files.newBufferedWriter(path, charset, new OpenOption[0]);){
                writer.append(doc.get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createType(TypeInformation type, boolean iface, boolean serializable, Consumer<TypeBuilder> consumer) {
        this.createType(type, TypeBuilder.defaultTypeCustomizer(iface, serializable, false), consumer);
    }

    @Override
    public void createType(TypeInformation type, Consumer<TypeDeclaration> typeCustomizer, Consumer<TypeBuilder> consumer) {
        this.createNew(type.getName(), (ast, cu) -> {
            TypeDeclaration td = PackageTypeBuilder.createType(ast, cu, typeCustomizer, type);
            cu.types().add(td);
            consumer.accept(new ClassTypeBuilder((AST)ast, (CompilationUnit)cu, td, this.typeLookup, this.typeResolver));
        });
    }

    @Override
    public void createEnum(TypeInformation type, Set<String> literals, BiConsumer<String, EnumConstantDeclaration> constantCustomizer, boolean withOriginalValues) {
        this.createNew(type.getName(), (ast, cu) -> cu.types().add(PackageTypeBuilder.createEnum(ast, cu, type, literals, constantCustomizer, withOriginalValues)));
    }

    @Override
    public void createProperty(PropertyInformation property) {
        throw new IllegalStateException("Unable to create property on package level");
    }

    @Override
    public void createBodyContent(BiFunction<AST, CompilationUnit, List<ASTNode>> consumer) {
        throw new IllegalStateException("Unable to create body content on package level");
    }

    private static TypeDeclaration createType(AST ast, CompilationUnit cu, Consumer<TypeDeclaration> typeCustomizer, TypeInformation type) {
        TypeDeclaration td = ast.newTypeDeclaration();
        JDTHelper.makePublic((BodyDeclaration)td);
        if (typeCustomizer != null) {
            typeCustomizer.accept(td);
        }
        PackageTypeBuilder.addJavadoc(ast, type, (BodyDeclaration)td);
        td.setName(ast.newSimpleName(type.getName()));
        return td;
    }

    private static EnumDeclaration createEnum(AST ast, CompilationUnit cu, TypeInformation type, Set<String> literals, BiConsumer<String, EnumConstantDeclaration> constantCustomizer, boolean withOriginalValues) {
        EnumDeclaration ed = ast.newEnumDeclaration();
        PackageTypeBuilder.addJavadoc(ast, type, (BodyDeclaration)ed);
        ed.setName(ast.newSimpleName(type.getName()));
        JDTHelper.makePublic((BodyDeclaration)ed);
        for (String literal : literals) {
            EnumConstantDeclaration l = ast.newEnumConstantDeclaration();
            l.setName(ast.newSimpleName(PackageTypeBuilder.asConstantName(literal)));
            if (withOriginalValues) {
                l.arguments().add(JDTHelper.newStringLiteral(ast, literal));
            }
            ed.enumConstants().add(l);
            if (constantCustomizer == null) continue;
            constantCustomizer.accept(literal, l);
        }
        if (withOriginalValues) {
            ed.bodyDeclarations().add(JDTHelper.createField(ast, "String", "value", Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD));
            MethodDeclaration md = ast.newMethodDeclaration();
            ed.bodyDeclarations().add(md);
            md.setConstructor(true);
            JDTHelper.makePrivate((BodyDeclaration)md);
            md.setName(ast.newSimpleName(type.getName()));
            md.parameters().add(JDTHelper.createParameter(ast, "String", "value", Modifier.ModifierKeyword.FINAL_KEYWORD));
            Block body = ast.newBlock();
            md.setBody(body);
            Assignment as = ast.newAssignment();
            FieldAccess fa = ast.newFieldAccess();
            fa.setExpression((Expression)ast.newThisExpression());
            fa.setName(ast.newSimpleName("value"));
            as.setLeftHandSide((Expression)fa);
            as.setRightHandSide((Expression)ast.newSimpleName("value"));
            body.statements().add(ast.newExpressionStatement((Expression)as));
            md = ast.newMethodDeclaration();
            ed.bodyDeclarations().add(md);
            md.setName(ast.newSimpleName("toString"));
            JDTHelper.makePublic((BodyDeclaration)md);
            JDTHelper.addSimpleAnnotation((BodyDeclaration)md, "Override");
            md.setReturnType2((org.eclipse.jdt.core.dom.Type)ast.newSimpleType((Name)ast.newSimpleName("String")));
            body = ast.newBlock();
            md.setBody(body);
            ReturnStatement ret = ast.newReturnStatement();
            body.statements().add(ret);
            fa = ast.newFieldAccess();
            fa.setExpression((Expression)ast.newThisExpression());
            fa.setName(ast.newSimpleName("value"));
            ret.setExpression((Expression)fa);
        }
        return ed;
    }

    public static Type lookupType(TypeReference type, Function<String, Type> typeLookup) {
        if (type instanceof Type) {
            return (Type)type;
        }
        return typeLookup.apply(type.getName());
    }

    public static void createProperty(AST ast, TypeDeclaration td, PropertyInformation property, Function<Type, String> typeLookup, Function<TypeReference, Type> typeResolver) {
        String name = PackageTypeBuilder.asPropertyName(property.getName());
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(name));
        FieldDeclaration fd = ast.newFieldDeclaration(fragment);
        fd.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        fd.setType(PackageTypeBuilder.createPropertyType(ast, property.getType(), typeLookup, typeResolver));
        Javadoc doc = PackageTypeBuilder.createJavadoc(ast, property.getSummary(), property.getDescription());
        if (doc != null) {
            fd.setJavadoc(doc);
        }
        td.bodyDeclarations().add(fd);
        MethodDeclaration setter = ast.newMethodDeclaration();
        td.bodyDeclarations().add(setter);
        JDTHelper.makePublic((BodyDeclaration)setter);
        setter.setName(ast.newSimpleName(PackageTypeBuilder.asMethodPropertyName("set", name)));
        SingleVariableDeclaration arg = ast.newSingleVariableDeclaration();
        arg.setName(ast.newSimpleName(name));
        arg.setType(PackageTypeBuilder.createPropertyType(ast, property.getType(), typeLookup, typeResolver));
        arg.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        setter.parameters().add(arg);
        Block body = ast.newBlock();
        FieldAccess fa = ast.newFieldAccess();
        fa.setName(ast.newSimpleName(name));
        fa.setExpression((Expression)ast.newThisExpression());
        Assignment assign = ast.newAssignment();
        assign.setLeftHandSide((Expression)fa);
        assign.setOperator(Assignment.Operator.ASSIGN);
        assign.setRightHandSide((Expression)ast.newSimpleName(name));
        ExpressionStatement expStmt = ast.newExpressionStatement((Expression)assign);
        body.statements().add(expStmt);
        setter.setBody(body);
        MethodDeclaration getter = ast.newMethodDeclaration();
        td.bodyDeclarations().add(getter);
        JDTHelper.makePublic((BodyDeclaration)getter);
        getter.setName(ast.newSimpleName(PackageTypeBuilder.asMethodPropertyName("get", name)));
        getter.setReturnType2(PackageTypeBuilder.createPropertyType(ast, property.getType(), typeLookup, typeResolver));
        Block body2 = ast.newBlock();
        ReturnStatement retStmt = ast.newReturnStatement();
        FieldAccess fa2 = ast.newFieldAccess();
        fa2.setName(ast.newSimpleName(name));
        fa2.setExpression((Expression)ast.newThisExpression());
        retStmt.setExpression((Expression)fa2);
        body2.statements().add(retStmt);
        getter.setBody(body2);
    }

    private static org.eclipse.jdt.core.dom.Type createPropertyType(AST ast, Type type, Function<Type, String> typeLookup, Function<TypeReference, Type> typeResolver) {
        if (type instanceof CoreType) {
            Class clazz = ((CoreType)type).getJavaType();
            if (clazz.equals(Short.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.SHORT);
            }
            if (clazz.equals(Integer.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.INT);
            }
            if (clazz.equals(Long.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.LONG);
            }
            if (clazz.equals(Boolean.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.BOOLEAN);
            }
            if (clazz.equals(Double.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.DOUBLE);
            }
            if (clazz.equals(Float.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.FLOAT);
            }
            if (clazz.equals(Character.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.CHAR);
            }
            if (clazz.equals(Byte.TYPE)) {
                return ast.newPrimitiveType(PrimitiveType.BYTE);
            }
            return ast.newSimpleType(ast.newName(clazz.getName()));
        }
        if (type instanceof ArrayType) {
            boolean unique = ((ArrayType)type).isUnique();
            SimpleType rawCollectionType = unique ? ast.newSimpleType(ast.newName(TYPE_NAME_SET)) : ast.newSimpleType(ast.newName(TYPE_NAME_LIST));
            ParameterizedType collectionType = ast.newParameterizedType((org.eclipse.jdt.core.dom.Type)rawCollectionType);
            collectionType.typeArguments().add(PackageTypeBuilder.createPropertyType(ast, typeResolver.apply(((ArrayType)type).getItemType()), typeLookup, typeResolver));
            return collectionType;
        }
        return ast.newSimpleType(ast.newName(typeLookup.apply(type)));
    }

    private static void addJavadoc(AST ast, TypeInformation type, BodyDeclaration bd) {
        Javadoc doc = PackageTypeBuilder.createJavadoc(ast, type.getSummary(), type.getDescription());
        if (doc != null) {
            bd.setJavadoc(doc);
        }
    }

    private static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    private static Javadoc createJavadoc(AST ast, String title, String description) {
        TagElement tag;
        if (PackageTypeBuilder.isEmpty(title) && PackageTypeBuilder.isEmpty(description)) {
            return null;
        }
        Javadoc doc = ast.newJavadoc();
        if (title != null) {
            tag = ast.newTagElement();
            tag.fragments().add(JDTHelper.newText(ast, title));
            doc.tags().add(tag);
        }
        if (description != null) {
            tag = ast.newTagElement();
            tag.fragments().add(JDTHelper.newText(ast, "<p>" + description + "</p>"));
            doc.tags().add(tag);
        }
        return doc;
    }

    private static class ClassTypeBuilder
    implements TypeBuilder {
        private final AST ast;
        private final CompilationUnit cu;
        private final TypeDeclaration td;
        private final Function<Type, String> typeLookup;
        private final Function<TypeReference, Type> typeResolver;

        public ClassTypeBuilder(AST ast, CompilationUnit cu, TypeDeclaration td, Function<Type, String> typeLookup, Function<TypeReference, Type> typeResolver) {
            this.ast = ast;
            this.cu = cu;
            this.td = td;
            this.typeLookup = typeLookup;
            this.typeResolver = typeResolver;
        }

        @Override
        public void createBodyContent(BiFunction<AST, CompilationUnit, List<ASTNode>> consumer) {
            List<ASTNode> result = consumer.apply(this.ast, this.cu);
            if (result != null) {
                this.td.bodyDeclarations().addAll(result);
            }
        }

        @Override
        public void createType(TypeInformation type, Consumer<TypeDeclaration> typeCustomizer, Consumer<TypeBuilder> consumer) {
            TypeDeclaration td = PackageTypeBuilder.createType(this.ast, this.cu, typeCustomizer, type);
            this.td.bodyDeclarations().add(td);
            consumer.accept(new ClassTypeBuilder(this.ast, this.cu, td, this.typeLookup, this.typeResolver));
        }

        @Override
        public void createEnum(TypeInformation type, Set<String> literals, BiConsumer<String, EnumConstantDeclaration> constantCustomizer, boolean withOriginalValues) {
            EnumDeclaration ed = PackageTypeBuilder.createEnum(this.ast, this.cu, type, literals, constantCustomizer, withOriginalValues);
            this.td.bodyDeclarations().add(ed);
            JDTHelper.makeStatic((BodyDeclaration)ed);
        }

        @Override
        public void createProperty(PropertyInformation property) {
            PackageTypeBuilder.createProperty(this.ast, this.td, property, this.typeLookup, this.typeResolver);
        }
    }
}

