/*
 * Decompiled with CFR 0.152.
 */
package de.deltatree.pub.apis.easyfin;

import de.deltatree.pub.apis.easyfin.AccountsResult;
import de.deltatree.pub.apis.easyfin.BankData;
import de.deltatree.pub.apis.easyfin.EasyFin;
import de.deltatree.pub.apis.easyfin.HBCICallable;
import de.deltatree.pub.apis.easyfin.MyHBCICallback;
import de.deltatree.pub.apis.easyfin.MyHBCICallbackAnswers;
import de.deltatree.pub.apis.easyfin.TurnoversResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.callback.HBCICallbackUnsupported;
import org.kapott.hbci.concurrent.DefaultHBCIPassportFactory;
import org.kapott.hbci.concurrent.HBCIPassportFactory;
import org.kapott.hbci.concurrent.HBCIThreadFactory;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public class DefaultEasyFin
implements EasyFin {
    private final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new HBCIThreadFactory());
    private static final HBCIPassportFactory PASSPORT_FACTORY;
    private Properties props;
    private HBCICallback callback;
    private String pin;
    private String customerId;
    private String userId;
    private File passportFile;

    public DefaultEasyFin(final BankData bankData, Map<String, String> additionalHBCIConfiguration) {
        this.passportFile = new File("hbci---" + UUID.randomUUID().toString() + ".passport");
        this.passportFile.deleteOnExit();
        this.props = DefaultEasyFin.initProperties(bankData, additionalHBCIConfiguration, this.passportFile);
        this.callback = new MyHBCICallback(new MyHBCICallbackAnswers(){

            @Override
            public String getPin() {
                return DefaultEasyFin.this.pin;
            }

            @Override
            public String getUserId() {
                return DefaultEasyFin.this.userId;
            }

            @Override
            public BankData getBankData() {
                return bankData;
            }

            @Override
            public String getCustomerId() {
                return DefaultEasyFin.this.customerId;
            }
        });
    }

    @Override
    public Stream<GVRKUms.UmsLine> getTurnoversAsStream(final Konto account) {
        HBCICallable<TurnoversResult> callable = new HBCICallable<TurnoversResult>(this.props, this.callback, PASSPORT_FACTORY){

            @Override
            protected TurnoversResult execute(HBCIPassport passport, HBCIHandler handler) throws Exception {
                HBCIJob job = handler.newJob("KUmsAll");
                job.setParam("my", account);
                job.setParam("startdate", "1970-01-01");
                job.addToQueue();
                HBCIExecStatus ret = handler.execute();
                this.checkForFailure(ret);
                GVRKUms result = (GVRKUms)job.getJobResult();
                this.checkForFailure(result);
                List lines = result.getFlatData();
                return new TurnoversResult(lines);
            }

            private void checkForFailure(GVRKUms result) {
                if (!result.isOK()) {
                    throw new IllegalStateException("Fetching turnovers failed: " + result.getJobStatus().getErrorString() + " / " + result.getGlobStatus().getErrorString());
                }
            }

            private void checkForFailure(HBCIExecStatus result) {
                if (!result.isOK()) {
                    throw new IllegalStateException("Fetching turnovers failed: " + result.getErrorString() + " / " + result.getErrorString());
                }
            }
        };
        Future<TurnoversResult> submit = this.EXECUTOR.submit(callable);
        try {
            List<GVRKUms.UmsLine> result = submit.get().getTurnovers();
            return result.stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Konto> getAccounts() {
        HBCICallable<AccountsResult> callable = new HBCICallable<AccountsResult>(this.props, this.callback, PASSPORT_FACTORY){

            @Override
            protected AccountsResult execute(HBCIPassport passport, HBCIHandler handler) throws Exception {
                Konto[] accounts = passport.getAccounts();
                ArrayList<Konto> result = new ArrayList<Konto>();
                for (Konto account : accounts) {
                    result.add(account);
                }
                return new AccountsResult(result);
            }
        };
        Future<AccountsResult> submit = this.EXECUTOR.submit(callable);
        try {
            return submit.get().getAccounts();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clean() {
        this.EXECUTOR.shutdown();
        while (!this.EXECUTOR.isTerminated()) {
            try {
                this.EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        this.passportFile.delete();
    }

    private static Properties initProperties(BankData bankData, Map<String, String> additionalHBCIConfiguration, File passportFile) {
        Properties p = new Properties();
        p.setProperty("default.hbciversion", bankData.getPinTanVersion());
        p.setProperty("log.loglevel.default", "1");
        p.setProperty("client.passport.default", "PinTan");
        p.setProperty("client.passport.hbciversion.default", bankData.getPinTanVersion());
        p.setProperty("client.passport.PinTan.checkcert", "1");
        p.setProperty("client.passport.PinTan.init", "1");
        p.setProperty("client.passport.PinTan.filename", passportFile.getName());
        for (String key : additionalHBCIConfiguration.keySet()) {
            p.setProperty(key, additionalHBCIConfiguration.get(key));
        }
        return p;
    }

    public DefaultEasyFin() {
    }

    public ExecutorService getEXECUTOR() {
        return this.EXECUTOR;
    }

    public Properties getProps() {
        return this.props;
    }

    public HBCICallback getCallback() {
        return this.callback;
    }

    public String getPin() {
        return this.pin;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public File getPassportFile() {
        return this.passportFile;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void setCallback(HBCICallback callback) {
        this.callback = callback;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassportFile(File passportFile) {
        this.passportFile = passportFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEasyFin)) {
            return false;
        }
        DefaultEasyFin other = (DefaultEasyFin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorService this$EXECUTOR = this.getEXECUTOR();
        ExecutorService other$EXECUTOR = other.getEXECUTOR();
        if (this$EXECUTOR == null ? other$EXECUTOR != null : !this$EXECUTOR.equals(other$EXECUTOR)) {
            return false;
        }
        Properties this$props = this.getProps();
        Properties other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        HBCICallback this$callback = this.getCallback();
        HBCICallback other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
            return false;
        }
        String this$pin = this.getPin();
        String other$pin = other.getPin();
        if (this$pin == null ? other$pin != null : !this$pin.equals(other$pin)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        File this$passportFile = this.getPassportFile();
        File other$passportFile = other.getPassportFile();
        return !(this$passportFile == null ? other$passportFile != null : !((Object)this$passportFile).equals(other$passportFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultEasyFin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorService $EXECUTOR = this.getEXECUTOR();
        result = result * 59 + ($EXECUTOR == null ? 43 : $EXECUTOR.hashCode());
        Properties $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        HBCICallback $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        String $pin = this.getPin();
        result = result * 59 + ($pin == null ? 43 : $pin.hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        File $passportFile = this.getPassportFile();
        result = result * 59 + ($passportFile == null ? 43 : ((Object)$passportFile).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultEasyFin(EXECUTOR=" + this.getEXECUTOR() + ", props=" + this.getProps() + ", callback=" + this.getCallback() + ", pin=" + this.getPin() + ", customerId=" + this.getCustomerId() + ", userId=" + this.getUserId() + ", passportFile=" + this.getPassportFile() + ")";
    }

    static {
        HBCIUtils.init((Properties)new Properties(), (HBCICallback)new HBCICallbackUnsupported());
        PASSPORT_FACTORY = new DefaultHBCIPassportFactory((Object)"Passports");
    }
}

