/*
 * Decompiled with CFR 0.152.
 */
package de.deltatree.pub.apis.easyfin;

import de.deltatree.pub.apis.easyfin.HBCICommandResult;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.concurrent.HBCIPassportFactory;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;

public abstract class HBCICallable<A extends HBCICommandResult>
implements Callable<A> {
    private final Properties properties;
    private final HBCICallback callback;
    private HBCIPassportFactory passportFactory;
    protected HBCIPassport passport = null;
    protected HBCIHandler handler = null;

    public HBCICallable(Properties properties, HBCICallback callback, HBCIPassportFactory passportFactory) {
        this.properties = properties;
        this.callback = callback;
        this.passportFactory = passportFactory;
    }

    @Override
    public A call() throws Exception {
        this.init();
        try {
            this.prepare();
            A a = this.execute(this.passport, this.handler);
            return a;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.done();
        }
    }

    private void init() {
        HBCIUtils.initThread((Properties)this.properties, (HBCICallback)this.callback);
    }

    private void prepare() throws Exception {
        this.passport = this.passportFactory.createPassport();
        if (this.passport != null) {
            this.handler = new HBCIHandler(this.properties.getProperty("default.hbciversion"), this.passport);
        }
    }

    protected abstract A execute(HBCIPassport var1, HBCIHandler var2) throws Exception;

    private void done() {
        if (this.handler != null) {
            this.handler.close();
        }
        if (this.passport != null) {
            this.passport.close();
        }
        HBCIUtils.doneThread();
    }
}

