/*
 * Decompiled with CFR 0.152.
 */
package de.deltatree.pub.apis.easyfin;

import de.deltatree.pub.apis.easyfin.AccountsResult;
import de.deltatree.pub.apis.easyfin.BankData;
import de.deltatree.pub.apis.easyfin.EasyFin;
import de.deltatree.pub.apis.easyfin.HBCICallable;
import de.deltatree.pub.apis.easyfin.MyHBCICallback;
import de.deltatree.pub.apis.easyfin.MyHBCICallbackAnswers;
import de.deltatree.pub.apis.easyfin.TurnoversResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.callback.HBCICallbackUnsupported;
import org.kapott.hbci.concurrent.DefaultHBCIPassportFactory;
import org.kapott.hbci.concurrent.HBCIPassportFactory;
import org.kapott.hbci.concurrent.HBCIThreadFactory;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public class DefaultEasyFin
implements EasyFin {
    private final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor((ThreadFactory)new HBCIThreadFactory());
    private static final HBCIPassportFactory PASSPORT_FACTORY;
    private final Properties props;
    private final HBCICallback callback;

    public DefaultEasyFin(final String loginName, final String password, final BankData bankData, Map<String, String> additionalHBCIConfiguration) {
        this.props = DefaultEasyFin.initProperties(bankData, additionalHBCIConfiguration);
        this.callback = new MyHBCICallback(new MyHBCICallbackAnswers(){

            @Override
            public String getVRNetKeyPin() {
                return password;
            }

            @Override
            public String getVRNetKey() {
                return loginName;
            }

            @Override
            public BankData getBankData() {
                return bankData;
            }
        });
    }

    @Override
    public Stream<GVRKUms.UmsLine> getTurnoversAsStream(final Konto account) {
        HBCICallable<TurnoversResult> callable = new HBCICallable<TurnoversResult>(this.props, this.callback, PASSPORT_FACTORY){

            @Override
            protected TurnoversResult execute(HBCIPassport passport, HBCIHandler handler) throws Exception {
                HBCIJob job = handler.newJob("KUmsAll");
                job.setParam("my", account);
                job.setParam("startdate", "1970-01-01");
                job.addToQueue();
                HBCIExecStatus ret = handler.execute();
                this.checkForFailure(ret);
                GVRKUms result = (GVRKUms)job.getJobResult();
                this.checkForFailure(result);
                List lines = result.getFlatData();
                return new TurnoversResult(lines);
            }

            private void checkForFailure(GVRKUms result) {
                if (!result.isOK()) {
                    throw new IllegalStateException("Fetching turnovers failed: " + result.getJobStatus().getErrorString() + " / " + result.getGlobStatus().getErrorString());
                }
            }

            private void checkForFailure(HBCIExecStatus result) {
                if (!result.isOK()) {
                    throw new IllegalStateException("Fetching turnovers failed: " + result.getErrorString() + " / " + result.getErrorString());
                }
            }
        };
        Future<TurnoversResult> submit = this.EXECUTOR.submit(callable);
        try {
            List<GVRKUms.UmsLine> result = submit.get().getTurnovers();
            return result.stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Konto> getAccounts() {
        HBCICallable<AccountsResult> callable = new HBCICallable<AccountsResult>(this.props, this.callback, PASSPORT_FACTORY){

            @Override
            protected AccountsResult execute(HBCIPassport passport, HBCIHandler handler) throws Exception {
                Konto[] accounts = passport.getAccounts();
                ArrayList<Konto> result = new ArrayList<Konto>();
                for (Konto account : accounts) {
                    result.add(account);
                }
                return new AccountsResult(result);
            }
        };
        Future<AccountsResult> submit = this.EXECUTOR.submit(callable);
        try {
            return submit.get().getAccounts();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clean() {
        this.EXECUTOR.shutdown();
        while (!this.EXECUTOR.isTerminated()) {
            try {
                this.EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static Properties initProperties(BankData bankData, Map<String, String> additionalHBCIConfiguration) {
        Properties p = new Properties();
        p.setProperty("default.hbciversion", bankData.getPinTanVersion());
        p.setProperty("log.loglevel.default", "1");
        p.setProperty("client.passport.default", "PinTan");
        p.setProperty("client.passport.hbciversion.default", bankData.getPinTanVersion());
        p.setProperty("client.passport.PinTan.checkcert", "1");
        p.setProperty("client.passport.PinTan.init", "1");
        File passportFile = new File("hbci---" + UUID.randomUUID().toString() + ".passport");
        passportFile.deleteOnExit();
        p.setProperty("client.passport.PinTan.filename", passportFile.getName());
        for (String key : additionalHBCIConfiguration.keySet()) {
            p.setProperty(key, additionalHBCIConfiguration.get(key));
        }
        return p;
    }

    static {
        HBCIUtils.init((Properties)new Properties(), (HBCICallback)new HBCICallbackUnsupported());
        PASSPORT_FACTORY = new DefaultHBCIPassportFactory((Object)"Passports");
    }
}

