/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.workspaces.migrations;

import de.deepamehta.core.Association;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.service.Migration;
import java.util.List;
import java.util.logging.Logger;

public class Migration5
extends Migration {
    private static final String PROP_WORKSPACE_ID = "dm4.workspaces.workspace_id";
    private long objects = 0L;
    private long initialized = 0L;
    private long ambiguous = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Initializing workspace properties");
        for (Topic topic : this.dm4.getAllTopics()) {
            this.initWorkspaceProperty((DeepaMehtaObject)topic);
        }
        for (Association assoc : this.dm4.getAllAssociations()) {
            this.initWorkspaceProperty((DeepaMehtaObject)assoc);
        }
        this.logger.info("########## Initializing workspace properties complete\n    Objects processed: " + this.objects + "\n    initialized: " + this.initialized + "\n    ambiguous: " + this.ambiguous);
        this.dm4.getTopicType("dm4.workspaces.workspace_facet").getAssocDef("dm4.workspaces.workspace").setChildCardinalityUri("dm4.core.one");
        this.dm4.getTopicByUri("de.workspaces.deepamehta").setUri("dm4.workspaces.deepamehta");
        for (Topic workspace : this.dm4.getTopicsByType("dm4.workspaces.workspace")) {
            workspace.update(this.mf.newTopicModel(this.mf.newChildTopicsModel().putRef("dm4.workspaces.sharing_mode", "dm4.workspaces.public")));
        }
    }

    private void initWorkspaceProperty(DeepaMehtaObject object) {
        List workspaces = object.getRelatedTopics("dm4.core.aggregation", "dm4.core.parent", "dm4.core.child", "dm4.workspaces.workspace");
        ++this.objects;
        switch (workspaces.size()) {
            case 0: {
                break;
            }
            case 1: {
                long workspaceId = ((RelatedTopic)workspaces.get(0)).getId();
                object.setProperty(PROP_WORKSPACE_ID, (Object)workspaceId, false);
                ++this.initialized;
                break;
            }
            default: {
                if (this.isUserAccountRelated(object)) break;
                this.logger.warning("##### " + this.info(object) + " has ambiguous workspace assignments (" + workspaces.size() + ") -- This object will get NO workspace assignment in DM 4.5 and will not be editable anymore");
                ++this.ambiguous;
            }
        }
    }

    private boolean isUserAccountRelated(DeepaMehtaObject object) {
        String typeUri = object.getTypeUri();
        return typeUri.equals("dm4.accesscontrol.user_account") || typeUri.equals("dm4.accesscontrol.username") || typeUri.equals("dm4.accesscontrol.password");
    }

    private String info(DeepaMehtaObject object) {
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", value=\"" + object.getSimpleValue() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }
}

