/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.workspaces.migrations;

import de.deepamehta.core.Association;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Migration;
import de.deepamehta.facets.FacetsService;
import de.deepamehta.workspaces.WorkspacesService;
import java.util.logging.Logger;

public class Migration9
extends Migration {
    @Inject
    private WorkspacesService workspacesService;
    @Inject
    private FacetsService facetsService;
    private long topicContext = 0L;
    private long assocContext = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Deleting workspace assignments of \"Mapcontext\" associations");
        for (Association assoc : this.dm4.getAssociationsByType("dm4.topicmaps.topic_mapcontext")) {
            this.deleteWorkspaceAssignment(assoc);
            ++this.topicContext;
        }
        for (Association assoc : this.dm4.getAssociationsByType("dm4.topicmaps.association_mapcontext")) {
            this.deleteWorkspaceAssignment(assoc);
            ++this.assocContext;
        }
        this.logger.info("########## Deleting workspace assignments of \"Mapcontext\" associations complete\n    \"Topic Mapcontext\" associations processed: " + this.topicContext + "\n    \"Association Mapcontext\" associations processed: " + this.assocContext);
    }

    private void deleteWorkspaceAssignment(Association assoc) {
        Topic workspace = this.workspacesService.getAssignedWorkspace(assoc.getId());
        if (workspace != null) {
            this.facetsService.updateFacet((DeepaMehtaObject)assoc, "dm4.workspaces.workspace_facet", this.mf.newFacetValueModel("dm4.workspaces.workspace").putDeletionRef(workspace.getId()));
            assoc.removeProperty("dm4.workspaces.workspace_id");
        }
    }
}

