/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.workspaces.migrations;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.Type;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Migration;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.logging.Logger;

public class Migration6
extends Migration {
    private static final String PROP_WORKSPACE_ID = "dm4.workspaces.workspace_id";
    @Inject
    private WorkspacesService wsService;
    private long deepamehtaWorkspaceId;
    private long types = 0L;
    private long standardTypes = 0L;
    private long assocDefs = 0L;
    private long configTopics = 0L;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DeepaMehta workspace");
        this.deepamehtaWorkspaceId = this.getDeepaMehtaWorkspace().getId();
        for (TopicType topicType : this.dms.getAllTopicTypes()) {
            this.assignWorkspace((Type)topicType);
        }
        for (AssociationType assocType : this.dms.getAllAssociationTypes()) {
            this.assignWorkspace((Type)assocType);
        }
        this.logger.info("########## Assigning standard association definitions (and their view config topics) to DeepaMehta workspace complete.\n    Types processed: " + this.types + "\n    Standard types: " + this.standardTypes + "\n    Association definitions: " + this.assocDefs + "\n    View config topics: " + this.configTopics);
    }

    void assignWorkspace(Type type) {
        ++this.types;
        if (this.isDeepaMehtaStandardType(type)) {
            ++this.standardTypes;
            for (AssociationDefinition assocDef : type.getAssocDefs()) {
                ++this.assocDefs;
                this.assignToDeepamehtaWorkspace((DeepaMehtaObject)assocDef);
                for (Topic configTopic : assocDef.getViewConfig().getConfigTopics()) {
                    ++this.configTopics;
                    this.assignToDeepamehtaWorkspace((DeepaMehtaObject)configTopic);
                }
            }
        }
    }

    void assignToDeepamehtaWorkspace(DeepaMehtaObject object) {
        this.wsService.assignToWorkspace(object, this.deepamehtaWorkspaceId);
    }

    private Topic getDeepaMehtaWorkspace() {
        return this.wsService.getWorkspace("dm4.workspaces.deepamehta");
    }

    private boolean isDeepaMehtaStandardType(Type type) {
        return type.getUri().startsWith("dm4.");
    }
}

