/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.workspaces;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.Type;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Cookies;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.accesscontrol.SharingMode;
import de.deepamehta.core.service.event.IntroduceAssociationTypeListener;
import de.deepamehta.core.service.event.IntroduceTopicTypeListener;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.plugins.facets.model.FacetValue;
import de.deepamehta.plugins.facets.service.FacetsService;
import de.deepamehta.plugins.topicmaps.service.TopicmapsService;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/workspace")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkspacesPlugin
extends PluginActivator
implements WorkspacesService,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PostCreateTopicListener,
PostCreateAssociationListener {
    private static final String PROP_WORKSPACE_ID = "dm4.workspaces.workspace_id";
    private static final String PARAM_NO_WORKSPACE_ASSIGNMENT = "no_workspace_assignment";
    @Inject
    private FacetsService facetsService;
    @Inject
    private TopicmapsService topicmapsService;
    @Context
    private UriInfo uriInfo;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/{name}/{uri:[^/]*?}/{sharing_mode_uri}")
    @Transactional
    public Topic createWorkspace(@PathParam(value="name") String name, @PathParam(value="uri") String uri, @PathParam(value="sharing_mode_uri") SharingMode sharingMode) {
        this.logger.info("Creating workspace \"" + name + "\" (uri=\"" + uri + "\", sharingMode=" + sharingMode + ")");
        Topic workspace = this.dms.createTopic(new TopicModel(uri, "dm4.workspaces.workspace", new ChildTopicsModel().put("dm4.workspaces.name", (Object)name).putRef("dm4.workspaces.sharing_mode", sharingMode.getUri())));
        Topic topicmap = this.topicmapsService.createTopicmap("untitled", "dm4.webclient.default_topicmap_renderer");
        this.assignToWorkspace((DeepaMehtaObject)topicmap, workspace.getId());
        return workspace;
    }

    @Override
    @GET
    @Path(value="/{uri}")
    public Topic getWorkspace(@PathParam(value="uri") String uri) {
        Topic workspace = this.dms.getTopic("uri", new SimpleValue(uri));
        if (workspace == null) {
            throw new RuntimeException("Workspace \"" + uri + "\" does not exist");
        }
        return workspace;
    }

    @Override
    @GET
    @Path(value="/{id}/topics/{type_uri}")
    public ResultList<RelatedTopic> getAssignedTopics(@PathParam(value="id") long workspaceId, @PathParam(value="type_uri") String topicTypeUri) {
        ResultList topics = this.dms.getTopics(topicTypeUri, 0);
        this.applyWorkspaceFilter(topics.iterator(), workspaceId);
        return topics;
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public Topic getAssignedWorkspace(@PathParam(value="id") long objectId) {
        long workspaceId = this.getAssignedWorkspaceId(objectId);
        if (workspaceId == -1L) {
            return null;
        }
        return this.dms.getTopic(workspaceId);
    }

    @Override
    public boolean isAssignedToWorkspace(long objectId, long workspaceId) {
        return this.getAssignedWorkspaceId(objectId) == workspaceId;
    }

    @PUT
    @Path(value="/{workspace_id}/object/{object_id}")
    @Transactional
    public Directives assignToWorkspace(@PathParam(value="object_id") long objectId, @PathParam(value="workspace_id") long workspaceId) {
        this.assignToWorkspace(this.dms.getObject(objectId), workspaceId);
        return Directives.get();
    }

    @Override
    public void assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        this.checkArgument(workspaceId);
        this._assignToWorkspace(object, workspaceId);
    }

    @Override
    public void assignTypeToWorkspace(Type type, long workspaceId) {
        this.assignToWorkspace((DeepaMehtaObject)type, workspaceId);
        for (Topic configTopic : type.getViewConfig().getConfigTopics()) {
            this._assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
        }
        for (AssociationDefinition assocDef : type.getAssocDefs()) {
            this._assignToWorkspace((DeepaMehtaObject)assocDef, workspaceId);
            for (Topic configTopic : assocDef.getViewConfig().getConfigTopics()) {
                this._assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
            }
        }
    }

    public void introduceTopicType(TopicType topicType) {
        long workspaceId = this.workspaceIdForType((Type)topicType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((Type)topicType, workspaceId);
    }

    public void introduceAssociationType(AssociationType assocType) {
        long workspaceId = this.workspaceIdForType((Type)assocType);
        if (workspaceId == -1L) {
            return;
        }
        this.assignTypeToWorkspace((Type)assocType, workspaceId);
    }

    public void postCreateTopic(Topic topic) {
        if (this.abortAssignment((DeepaMehtaObject)topic)) {
            return;
        }
        if (this.isWorkspaceDescription(topic)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this.assignToWorkspace((DeepaMehtaObject)topic, workspaceId);
    }

    public void postCreateAssociation(Association assoc) {
        if (this.abortAssignment((DeepaMehtaObject)assoc)) {
            return;
        }
        if (this.isWorkspaceAssignment(assoc)) {
            return;
        }
        long workspaceId = this.workspaceId();
        if (workspaceId == -1L) {
            return;
        }
        this.assignToWorkspace((DeepaMehtaObject)assoc, workspaceId);
    }

    private long workspaceId() {
        Cookies cookies = Cookies.get();
        if (!cookies.has("dm4_workspace_id")) {
            return -1L;
        }
        return cookies.getLong("dm4_workspace_id");
    }

    private long workspaceIdForType(Type type) {
        return this.workspaceId() == -1L && this.isDeepaMehtaStandardType(type) ? this.getDeepaMehtaWorkspace().getId() : -1L;
    }

    private long getAssignedWorkspaceId(long objectId) {
        return this.dms.hasProperty(objectId, PROP_WORKSPACE_ID) ? (Long)this.dms.getProperty(objectId, PROP_WORKSPACE_ID) : -1L;
    }

    private void _assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        try {
            this.facetsService.updateFacet(object, "dm4.workspaces.workspace_facet", new FacetValue("dm4.workspaces.workspace").putRef(workspaceId));
            object.setProperty(PROP_WORKSPACE_ID, (Object)workspaceId, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning " + this.info(object) + " to workspace " + workspaceId + " failed (" + object + ")", e);
        }
    }

    private boolean isDeepaMehtaStandardType(Type type) {
        return type.getUri().startsWith("dm4.");
    }

    private boolean isWorkspaceDescription(Topic topic) {
        return topic.getTypeUri().equals("dm4.workspaces.description");
    }

    private boolean isWorkspaceAssignment(Association assoc) {
        Topic topic;
        return assoc.getTypeUri().equals("dm4.core.aggregation") && (topic = assoc.getTopic("dm4.core.child")) != null && topic.getTypeUri().equals("dm4.workspaces.workspace");
    }

    private Topic getDeepaMehtaWorkspace() {
        return this.getWorkspace("dm4.workspaces.deepamehta");
    }

    private void applyWorkspaceFilter(Iterator<? extends Topic> topics, long workspaceId) {
        while (topics.hasNext()) {
            Topic topic = topics.next();
            if (this.isAssignedToWorkspace(topic.getId(), workspaceId)) continue;
            topics.remove();
        }
    }

    private void checkArgument(long topicId) {
        String typeUri = this.dms.getTopic(topicId).getTypeUri();
        if (!typeUri.equals("dm4.workspaces.workspace")) {
            throw new IllegalArgumentException("Topic " + topicId + " is not a workspace (but of type \"" + typeUri + "\")");
        }
    }

    private boolean abortAssignment(DeepaMehtaObject object) {
        try {
            String value = (String)this.uriInfo.getQueryParameters().getFirst((Object)PARAM_NO_WORKSPACE_ASSIGNMENT);
            if (value == null) {
                return false;
            }
            if (!value.equals("false") && !value.equals("true")) {
                throw new RuntimeException("\"" + value + "\" is an unexpected value for the \"" + PARAM_NO_WORKSPACE_ASSIGNMENT + "\" query parameter (expected are \"false\" or \"true\")");
            }
            boolean abort = value.equals("true");
            if (abort) {
                this.logger.info("### Workspace assignment for " + this.info(object) + " ABORTED -- \"" + PARAM_NO_WORKSPACE_ASSIGNMENT + "\" query parameter detected");
            }
            return abort;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private String info(DeepaMehtaObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssociationType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }
}

