/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.workspaces;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.Type;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Cookies;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.event.IntroduceAssociationTypeListener;
import de.deepamehta.core.service.event.IntroduceTopicTypeListener;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.plugins.facets.model.FacetValue;
import de.deepamehta.plugins.facets.service.FacetsService;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.List;
import java.util.logging.Logger;

public class WorkspacesPlugin
extends PluginActivator
implements WorkspacesService,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PostCreateTopicListener,
PostCreateAssociationListener {
    private static final String DEFAULT_WORKSPACE_NAME = "DeepaMehta";
    private static final String DEFAULT_WORKSPACE_URI = "de.workspaces.deepamehta";
    @Inject
    private FacetsService facetsService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public List<RelatedTopic> getAssignedWorkspaces(DeepaMehtaObject object) {
        return this.facetsService.getFacets(object, "dm4.workspaces.workspace_facet").getItems();
    }

    @Override
    public boolean isAssignedToWorkspace(Topic topic, long workspaceId) {
        return this.facetsService.hasFacet(topic.getId(), "dm4.workspaces.workspace_facet", workspaceId);
    }

    @Override
    public Topic getDefaultWorkspace() {
        return this.fetchDefaultWorkspace();
    }

    @Override
    public void assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        this.checkArgument(workspaceId);
        this._assignToWorkspace(object, workspaceId);
    }

    @Override
    public void assignTypeToWorkspace(Type type, long workspaceId) {
        this.checkArgument(workspaceId);
        this._assignToWorkspace((DeepaMehtaObject)type, workspaceId);
        for (Topic configTopic : type.getViewConfig().getConfigTopics()) {
            this._assignToWorkspace((DeepaMehtaObject)configTopic, workspaceId);
        }
    }

    @Override
    public Topic createWorkspace(String name) {
        return this.createWorkspace(name, null);
    }

    @Override
    public Topic createWorkspace(String name, String uri) {
        this.logger.info("Creating workspace \"" + name + "\"");
        return this.dms.createTopic(new TopicModel(uri, "dm4.workspaces.workspace", new ChildTopicsModel().put("dm4.workspaces.name", (Object)name)));
    }

    public void postInstall() {
        this.createWorkspace(DEFAULT_WORKSPACE_NAME, DEFAULT_WORKSPACE_URI);
    }

    public void introduceTopicType(TopicType topicType) {
        long workspaceId = -1L;
        try {
            workspaceId = this.workspaceIdForType((Type)topicType);
            if (workspaceId == -1L) {
                return;
            }
            this.assignTypeToWorkspace((Type)topicType, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning topic type \"" + topicType.getUri() + "\" to workspace " + workspaceId + " failed", e);
        }
    }

    public void introduceAssociationType(AssociationType assocType) {
        long workspaceId = -1L;
        try {
            workspaceId = this.workspaceIdForType((Type)assocType);
            if (workspaceId == -1L) {
                return;
            }
            this.assignTypeToWorkspace((Type)assocType, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning association type \"" + assocType.getUri() + "\" to workspace " + workspaceId + " failed", e);
        }
    }

    public void postCreateTopic(Topic topic) {
        long workspaceId = -1L;
        try {
            if (this.isOwnTopic(topic)) {
                return;
            }
            workspaceId = this.workspaceId();
            if (workspaceId == -1L) {
                return;
            }
            this.assignToWorkspace((DeepaMehtaObject)topic, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning topic " + topic.getId() + " to workspace " + workspaceId + " failed", e);
        }
    }

    public void postCreateAssociation(Association assoc) {
        long workspaceId = -1L;
        try {
            if (this.isOwnAssociation(assoc)) {
                return;
            }
            workspaceId = this.workspaceId();
            if (workspaceId == -1L) {
                return;
            }
            this.assignToWorkspace((DeepaMehtaObject)assoc, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning association " + assoc.getId() + " to workspace " + workspaceId + " failed", e);
        }
    }

    private long workspaceId() {
        Cookies cookies = Cookies.get();
        if (!cookies.has("dm4_workspace_id")) {
            return -1L;
        }
        return cookies.getLong("dm4_workspace_id");
    }

    private long workspaceIdForType(Type type) {
        Topic defaultWorkspace;
        long workspaceId = this.workspaceId();
        if (workspaceId != -1L) {
            return workspaceId;
        }
        if (this.isDeepaMehtaStandardType(type) && (defaultWorkspace = this.fetchDefaultWorkspace()) != null) {
            return defaultWorkspace.getId();
        }
        return -1L;
    }

    private void _assignToWorkspace(DeepaMehtaObject object, long workspaceId) {
        FacetValue value = new FacetValue("dm4.workspaces.workspace").addRef(workspaceId);
        this.facetsService.updateFacet(object, "dm4.workspaces.workspace_facet", value);
    }

    private boolean isDeepaMehtaStandardType(Type type) {
        return type.getUri().startsWith("dm4.");
    }

    private boolean isOwnTopic(Topic topic) {
        return topic.getTypeUri().startsWith("dm4.workspaces.");
    }

    private boolean isOwnAssociation(Association assoc) {
        Topic topic;
        return assoc.getTypeUri().equals("dm4.core.aggregation") && (topic = assoc.getTopic("dm4.core.child")) != null && topic.getTypeUri().equals("dm4.workspaces.workspace");
    }

    private Topic fetchDefaultWorkspace() {
        return this.dms.getTopic("uri", new SimpleValue(DEFAULT_WORKSPACE_URI));
    }

    private void checkArgument(long topicId) {
        String typeUri = this.dms.getTopic(topicId).getTypeUri();
        if (!typeUri.equals("dm4.workspaces.workspace")) {
            throw new IllegalArgumentException("Topic " + topicId + " is not a workspace (but of type \"" + typeUri + "\")");
        }
    }
}

