/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.webservice;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.DirectivesResponse;
import de.deepamehta.core.service.PluginInfo;
import de.deepamehta.core.service.Transactional;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/core")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebservicePlugin
extends PluginActivator {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @GET
    @Path(value="/topic/{id}")
    public Topic getTopic(@PathParam(value="id") long topicId) {
        return this.dm4.getTopic(topicId);
    }

    @GET
    @Path(value="/topic/by_uri/{uri}")
    public Topic getTopicByUri(@PathParam(value="uri") String uri) {
        return this.dm4.getTopicByUri(uri);
    }

    @GET
    @Path(value="/topic/by_value/{key}/{value}")
    public Topic getTopicByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dm4.getTopicByValue(key, value);
    }

    @GET
    @Path(value="/topic/multi/by_value/{key}/{value}")
    public List<Topic> getTopicsByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dm4.getTopicsByValue(key, value);
    }

    @GET
    @Path(value="/topic/by_type/{topic_type_uri}")
    public List<Topic> getTopicsByType(@PathParam(value="topic_type_uri") String topicTypeUri) {
        return this.dm4.getTopicsByType(topicTypeUri);
    }

    @GET
    @Path(value="/topic")
    public List<Topic> searchTopics(@QueryParam(value="search") String searchTerm, @QueryParam(value="field") String fieldUri) {
        return this.dm4.searchTopics(searchTerm, fieldUri);
    }

    @POST
    @Path(value="/topic")
    @Transactional
    public DirectivesResponse createTopic(TopicModel model) {
        return new DirectivesResponse((DeepaMehtaObject)this.dm4.createTopic(model));
    }

    @PUT
    @Path(value="/topic/{id}")
    @Transactional
    public DirectivesResponse updateTopic(@PathParam(value="id") long topicId, TopicModel model) {
        if (model.getId() != -1L && topicId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(topicId);
        this.dm4.updateTopic(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/topic/{id}")
    @Transactional
    public DirectivesResponse deleteTopic(@PathParam(value="id") long topicId) {
        this.dm4.deleteTopic(topicId);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/association/{id}")
    public Association getAssociation(@PathParam(value="id") long assocId) {
        return this.dm4.getAssociation(assocId);
    }

    @GET
    @Path(value="/assoc/by_value/{key}/{value}")
    public Association getAssociationByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dm4.getAssociationByValue(key, value);
    }

    @GET
    @Path(value="/assoc/multi/by_value/{key}/{value}")
    public List<Association> getAssociationsByValue(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dm4.getAssociationsByValue(key, value);
    }

    @GET
    @Path(value="/association/{assoc_type_uri}/{topic1_id}/{topic2_id}/{role_type1_uri}/{role_type2_uri}")
    public Association getAssociation(@PathParam(value="assoc_type_uri") String assocTypeUri, @PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="role_type1_uri") String roleTypeUri1, @PathParam(value="role_type2_uri") String roleTypeUri2) {
        return this.dm4.getAssociation(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}")
    public List<Association> getAssociations(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id) {
        return this.dm4.getAssociations(topic1Id, topic2Id);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}/{assoc_type_uri}")
    public List<Association> getAssociations(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="assoc_type_uri") String assocTypeUri) {
        return this.dm4.getAssociations(topic1Id, topic2Id, assocTypeUri);
    }

    @POST
    @Path(value="/association")
    @Transactional
    public DirectivesResponse createAssociation(AssociationModel model) {
        return new DirectivesResponse((DeepaMehtaObject)this.dm4.createAssociation(model));
    }

    @PUT
    @Path(value="/association/{id}")
    @Transactional
    public DirectivesResponse updateAssociation(@PathParam(value="id") long assocId, AssociationModel model) {
        if (model.getId() != -1L && assocId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(assocId);
        this.dm4.updateAssociation(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/association/{id}")
    @Transactional
    public DirectivesResponse deleteAssociation(@PathParam(value="id") long assocId) {
        this.dm4.deleteAssociation(assocId);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/topictype/{uri}")
    public TopicType getTopicType(@PathParam(value="uri") String uri) {
        return this.dm4.getTopicType(uri);
    }

    @GET
    @Path(value="/topictype/topic/{id}")
    public TopicType getTopicTypeImplicitly(@PathParam(value="id") long topicId) {
        return this.dm4.getTopicTypeImplicitly(topicId);
    }

    @GET
    @Path(value="/topictype/all")
    public List<TopicType> getAllTopicTypes() {
        return this.dm4.getAllTopicTypes();
    }

    @POST
    @Path(value="/topictype")
    @Transactional
    public TopicType createTopicType(TopicTypeModel model) {
        return this.dm4.createTopicType(model);
    }

    @PUT
    @Path(value="/topictype")
    @Transactional
    public DirectivesResponse updateTopicType(TopicTypeModel model) {
        this.dm4.updateTopicType(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/topictype/{uri}")
    @Transactional
    public DirectivesResponse deleteTopicType(@PathParam(value="uri") String uri) {
        this.dm4.deleteTopicType(uri);
        return new DirectivesResponse();
    }

    @GET
    @Path(value="/assoctype/{uri}")
    public AssociationType getAssociationType(@PathParam(value="uri") String uri) {
        return this.dm4.getAssociationType(uri);
    }

    @GET
    @Path(value="/assoctype/assoc/{id}")
    public AssociationType getAssociationTypeImplicitly(@PathParam(value="id") long assocId) {
        return this.dm4.getAssociationTypeImplicitly(assocId);
    }

    @GET
    @Path(value="/assoctype/all")
    public List<AssociationType> getAssociationAllTypes() {
        return this.dm4.getAllAssociationTypes();
    }

    @POST
    @Path(value="/assoctype")
    @Transactional
    public AssociationType createAssociationType(AssociationTypeModel model) {
        return this.dm4.createAssociationType(model);
    }

    @PUT
    @Path(value="/assoctype")
    @Transactional
    public DirectivesResponse updateAssociationType(AssociationTypeModel model) {
        this.dm4.updateAssociationType(model);
        return new DirectivesResponse();
    }

    @DELETE
    @Path(value="/assoctype/{uri}")
    @Transactional
    public DirectivesResponse deleteAssociationType(@PathParam(value="uri") String uri) {
        this.dm4.deleteAssociationType(uri);
        return new DirectivesResponse();
    }

    @POST
    @Path(value="/roletype")
    @Transactional
    public Topic createRoleType(TopicModel model) {
        return this.dm4.createRoleType(model);
    }

    @GET
    @Path(value="/plugin")
    public List<PluginInfo> getPluginInfo() {
        return this.dm4.getPluginInfo();
    }

    @GET
    @Path(value="/topic/{id}/related_topics")
    public List<RelatedTopic> getTopicRelatedTopics(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri) {
        Topic topic = this.dm4.getTopic(topicId);
        return this.getRelatedTopics((DeepaMehtaObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @GET
    @Path(value="/topic/{id}/related_assocs")
    public List<RelatedAssociation> getTopicRelatedAssociations(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Topic topic = this.dm4.getTopic(topicId);
        return this.getRelatedAssociations((DeepaMehtaObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    @GET
    @Path(value="/association/{id}/related_topics")
    public List<RelatedTopic> getAssociationRelatedTopics(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri) {
        Association assoc = this.dm4.getAssociation(assocId);
        return this.getRelatedTopics((DeepaMehtaObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @GET
    @Path(value="/association/{id}/related_assocs")
    public List<RelatedAssociation> getAssociationRelatedAssociations(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Association assoc = this.dm4.getAssociation(assocId);
        return this.getRelatedAssociations((DeepaMehtaObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    private List<RelatedTopic> getRelatedTopics(DeepaMehtaObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        String operation = "Fetching related topics of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\")";
        try {
            this.logger.info(operation + " " + paramInfo);
            return object.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }

    private List<RelatedAssociation> getRelatedAssociations(DeepaMehtaObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        String operation = "Fetching related associations of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")";
        try {
            this.logger.info(operation + " " + paramInfo);
            return object.getRelatedAssociations(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }
}

