/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.webservice.provider;

import de.deepamehta.core.JSONEnabled;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class JSONEnabledProvider
implements MessageBodyWriter<JSONEnabled> {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONEnabled.class.isAssignableFrom(type) && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(JSONEnabled jsonEnabled, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(JSONEnabled jsonEnabled, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(entityStream));
            jsonEnabled.toJSON().write((Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing message body failed", e);
        }
    }
}

