/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.webservice.provider;

import de.deepamehta.core.service.accesscontrol.AccessControlException;
import de.deepamehta.core.util.JavaUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class CatchAllExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Response toResponse(Throwable e) {
        if (e instanceof WebApplicationException) {
            return ((WebApplicationException)e).getResponse();
        }
        Response.Status status = this.hasNestedAccessControlException(e) ? Response.Status.UNAUTHORIZED : Response.Status.INTERNAL_SERVER_ERROR;
        this.logger.log(Level.SEVERE, this.errorMessage(status), e);
        return Response.status((Response.Status)status).build();
    }

    private boolean hasNestedAccessControlException(Throwable e) {
        while (e != null) {
            if (e instanceof AccessControlException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private String errorMessage(Response.Status status) {
        return "Request \"" + JavaUtils.requestInfo((HttpServletRequest)this.request) + "\" failed. Generating " + JavaUtils.responseInfo((Response.Status)status) + ". The original exception/error is:";
    }
}

