/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.webservice;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.PluginInfo;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.Transactional;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/core")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebservicePlugin
extends PluginActivator {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @GET
    @Path(value="/topic/{id}")
    public Topic getTopic(@PathParam(value="id") long topicId) {
        return this.dms.getTopic(topicId);
    }

    @GET
    @Path(value="/topic/by_value/{key}/{value}")
    public Topic getTopic(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dms.getTopic(key, value);
    }

    @GET
    @Path(value="/topic/multi/by_value/{key}/{value}")
    public List<Topic> getTopics(@PathParam(value="key") String key, @PathParam(value="value") SimpleValue value) {
        return this.dms.getTopics(key, value);
    }

    @GET
    @Path(value="/topic/by_type/{type_uri}")
    public ResultList<RelatedTopic> getTopics(@PathParam(value="type_uri") String typeUri, @QueryParam(value="max_result_size") int maxResultSize) {
        return this.dms.getTopics(typeUri, maxResultSize);
    }

    @GET
    @Path(value="/topic")
    public List<Topic> searchTopics(@QueryParam(value="search") String searchTerm, @QueryParam(value="field") String fieldUri) {
        return this.dms.searchTopics(searchTerm, fieldUri);
    }

    @POST
    @Path(value="/topic")
    @Transactional
    public Topic createTopic(TopicModel model) {
        return this.dms.createTopic(model);
    }

    @PUT
    @Path(value="/topic/{id}")
    @Transactional
    public Directives updateTopic(@PathParam(value="id") long topicId, TopicModel model) {
        if (model.getId() != -1L && topicId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(topicId);
        this.dms.updateTopic(model);
        return Directives.get();
    }

    @DELETE
    @Path(value="/topic/{id}")
    @Transactional
    public Directives deleteTopic(@PathParam(value="id") long topicId) {
        this.dms.deleteTopic(topicId);
        return Directives.get();
    }

    @GET
    @Path(value="/association/{id}")
    public Association getAssociation(@PathParam(value="id") long assocId) {
        return this.dms.getAssociation(assocId);
    }

    @GET
    @Path(value="/association/{assoc_type_uri}/{topic1_id}/{topic2_id}/{role_type1_uri}/{role_type2_uri}")
    public Association getAssociation(@PathParam(value="assoc_type_uri") String assocTypeUri, @PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="role_type1_uri") String roleTypeUri1, @PathParam(value="role_type2_uri") String roleTypeUri2) {
        return this.dms.getAssociation(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}")
    public List<Association> getAssociations(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id) {
        return this.dms.getAssociations(topic1Id, topic2Id);
    }

    @GET
    @Path(value="/association/multiple/{topic1_id}/{topic2_id}/{assoc_type_uri}")
    public List<Association> getAssociations(@PathParam(value="topic1_id") long topic1Id, @PathParam(value="topic2_id") long topic2Id, @PathParam(value="assoc_type_uri") String assocTypeUri) {
        return this.dms.getAssociations(topic1Id, topic2Id, assocTypeUri);
    }

    @POST
    @Path(value="/association")
    @Transactional
    public Association createAssociation(AssociationModel model) {
        return this.dms.createAssociation(model);
    }

    @PUT
    @Path(value="/association/{id}")
    @Transactional
    public Directives updateAssociation(@PathParam(value="id") long assocId, AssociationModel model) {
        if (model.getId() != -1L && assocId != model.getId()) {
            throw new RuntimeException("ID mismatch in update request");
        }
        model.setId(assocId);
        this.dms.updateAssociation(model);
        return Directives.get();
    }

    @DELETE
    @Path(value="/association/{id}")
    @Transactional
    public Directives deleteAssociation(@PathParam(value="id") long assocId) {
        this.dms.deleteAssociation(assocId);
        return Directives.get();
    }

    @GET
    @Path(value="/topictype")
    public List<String> getTopicTypeUris() {
        return this.dms.getTopicTypeUris();
    }

    @GET
    @Path(value="/topictype/{uri}")
    public TopicType getTopicType(@PathParam(value="uri") String uri) {
        return this.dms.getTopicType(uri);
    }

    @GET
    @Path(value="/topictype/all")
    public List<TopicType> getAllTopicTypes() {
        return this.dms.getAllTopicTypes();
    }

    @POST
    @Path(value="/topictype")
    @Transactional
    public TopicType createTopicType(TopicTypeModel model) {
        return this.dms.createTopicType(model);
    }

    @PUT
    @Path(value="/topictype")
    @Transactional
    public Directives updateTopicType(TopicTypeModel model) {
        this.dms.updateTopicType(model);
        return Directives.get();
    }

    @DELETE
    @Path(value="/topictype/{uri}")
    @Transactional
    public Directives deleteTopicType(@PathParam(value="uri") String uri) {
        this.dms.deleteTopicType(uri);
        return Directives.get();
    }

    @GET
    @Path(value="/assoctype")
    public List<String> getAssociationTypeUris() {
        return this.dms.getAssociationTypeUris();
    }

    @GET
    @Path(value="/assoctype/{uri}")
    public AssociationType getAssociationType(@PathParam(value="uri") String uri) {
        return this.dms.getAssociationType(uri);
    }

    @GET
    @Path(value="/assoctype/all")
    public List<AssociationType> getAssociationAllTypes() {
        return this.dms.getAllAssociationTypes();
    }

    @POST
    @Path(value="/assoctype")
    @Transactional
    public AssociationType createAssociationType(AssociationTypeModel model) {
        return this.dms.createAssociationType(model);
    }

    @PUT
    @Path(value="/assoctype")
    @Transactional
    public Directives updateAssociationType(AssociationTypeModel model) {
        this.dms.updateAssociationType(model);
        return Directives.get();
    }

    @DELETE
    @Path(value="/assoctype/{uri}")
    @Transactional
    public Directives deleteAssociationType(@PathParam(value="uri") String uri) {
        this.dms.deleteAssociationType(uri);
        return Directives.get();
    }

    @POST
    @Path(value="/roletype")
    @Transactional
    public Topic createRoleType(TopicModel model) {
        return this.dms.createRoleType(model);
    }

    @GET
    @Path(value="/plugin")
    public List<PluginInfo> getPluginInfo() {
        return this.dms.getPluginInfo();
    }

    @GET
    @Path(value="/topic/{id}/related_topics")
    public ResultList<RelatedTopic> getTopicRelatedTopics(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri, @QueryParam(value="max_result_size") int maxResultSize) {
        Topic topic = this.dms.getTopic(topicId);
        return this.getRelatedTopics((DeepaMehtaObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
    }

    @GET
    @Path(value="/topic/{id}/related_assocs")
    public ResultList<RelatedAssociation> getTopicRelatedAssociations(@PathParam(value="id") long topicId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Topic topic = this.dms.getTopic(topicId);
        return this.getRelatedAssociations((DeepaMehtaObject)topic, "topic", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    @GET
    @Path(value="/association/{id}/related_topics")
    public ResultList<RelatedTopic> getAssociationRelatedTopics(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_topic_type_uri") String othersTopicTypeUri, @QueryParam(value="max_result_size") int maxResultSize) {
        Association assoc = this.dms.getAssociation(assocId);
        return this.getRelatedTopics((DeepaMehtaObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
    }

    @GET
    @Path(value="/association/{id}/related_assocs")
    public ResultList<RelatedAssociation> getAssociationRelatedAssociations(@PathParam(value="id") long assocId, @QueryParam(value="assoc_type_uri") String assocTypeUri, @QueryParam(value="my_role_type_uri") String myRoleTypeUri, @QueryParam(value="others_role_type_uri") String othersRoleTypeUri, @QueryParam(value="others_assoc_type_uri") String othersAssocTypeUri) {
        Association assoc = this.dms.getAssociation(assocId);
        return this.getRelatedAssociations((DeepaMehtaObject)assoc, "association", assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
    }

    private ResultList<RelatedTopic> getRelatedTopics(DeepaMehtaObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri, int maxResultSize) {
        String operation = "Fetching related topics of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersTopicTypeUri=\"" + othersTopicTypeUri + "\", maxResultSize=" + maxResultSize + ")";
        try {
            this.logger.info(operation + " " + paramInfo);
            return object.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri, maxResultSize);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }

    private ResultList<RelatedAssociation> getRelatedAssociations(DeepaMehtaObject object, String objectInfo, String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        String operation = "Fetching related associations of " + objectInfo + " " + object.getId();
        String paramInfo = "(assocTypeUri=\"" + assocTypeUri + "\", myRoleTypeUri=\"" + myRoleTypeUri + "\", othersRoleTypeUri=\"" + othersRoleTypeUri + "\", othersAssocTypeUri=\"" + othersAssocTypeUri + "\")";
        try {
            this.logger.info(operation + " " + paramInfo);
            return object.getRelatedAssociations(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed " + paramInfo, e);
        }
    }
}

