/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.webservice.provider;

import de.deepamehta.core.util.JavaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONObject;

@Provider
public class ObjectProvider
implements MessageBodyReader<Object> {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getJSONConstructor(type) != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            String json = JavaUtils.readText((InputStream)entityStream);
            return this.getJSONConstructor(type).newInstance(new JSONObject(json));
        }
        catch (Exception e) {
            throw new RuntimeException("Creating a " + type.getName() + " object from message body failed", e);
        }
    }

    private Constructor<?> getJSONConstructor(Class<?> type) {
        try {
            return type.getDeclaredConstructor(JSONObject.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

