/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.webclient;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaType;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Directive;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.event.AllPluginsActiveListener;
import de.deepamehta.core.service.event.IntroduceAssociationTypeListener;
import de.deepamehta.core.service.event.IntroduceTopicTypeListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PreUpdateTopicListener;
import java.awt.Desktop;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/webclient")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WebclientPlugin
extends PluginActivator
implements AllPluginsActiveListener,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
PreUpdateTopicListener,
PostUpdateTopicListener {
    private static final String VIEW_CONFIG_LABEL = "View Configuration";
    private boolean hasWebclientLaunched = false;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @GET
    @Path(value="/search")
    @Transactional
    public Topic searchTopics(@QueryParam(value="search") String searchTerm, @QueryParam(value="field") String fieldUri) {
        try {
            this.logger.info("searchTerm=\"" + searchTerm + "\", fieldUri=\"" + fieldUri + "\"");
            List singleTopics = this.dm4.searchTopics(searchTerm, fieldUri);
            Set<Topic> topics = this.findSearchableUnits(singleTopics);
            this.logger.info(singleTopics.size() + " single topics found, " + topics.size() + " searchable units");
            return this.createSearchTopic(searchTerm, topics);
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed", e);
        }
    }

    @GET
    @Path(value="/search/by_type/{type_uri}")
    @Transactional
    public Topic getTopics(@PathParam(value="type_uri") String typeUri) {
        try {
            this.logger.info("typeUri=\"" + typeUri + "\"");
            String searchTerm = this.dm4.getTopicType(typeUri).getSimpleValue() + "(s)";
            List topics = this.dm4.getTopicsByType(typeUri);
            return this.createSearchTopic(searchTerm, topics);
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed", e);
        }
    }

    @GET
    @Path(value="/topic/{id}/related_topics")
    public List<RelatedTopic> getRelatedTopics(@PathParam(value="id") long topicId) {
        Topic topic = this.dm4.getTopic(topicId);
        List topics = topic.getRelatedTopics(null);
        Iterator i = topics.iterator();
        int removed = 0;
        while (i.hasNext()) {
            RelatedTopic relTopic = (RelatedTopic)i.next();
            if (!this.isDirectModelledChildTopic(relTopic, topic)) continue;
            i.remove();
            ++removed;
        }
        this.logger.fine("### " + removed + " topics are removed from result set of topic " + topicId);
        return topics;
    }

    public void allPluginsActive() {
        String webclientUrl = this.getWebclientUrl();
        if (this.hasWebclientLaunched) {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\") ABORTED -- already launched");
            return;
        }
        try {
            this.logger.info("### Launching webclient (url=\"" + webclientUrl + "\")");
            Desktop.getDesktop().browse(new URI(webclientUrl));
            this.hasWebclientLaunched = true;
        }
        catch (Exception e) {
            this.logger.warning("### Launching webclient failed (" + e + ")");
            this.logger.warning("### To launch it manually: " + webclientUrl);
        }
    }

    public void preUpdateTopic(Topic topic, TopicModel newModel) {
        if (topic.getTypeUri().equals("dm4.files.file") && newModel.getTypeUri().equals("dm4.webclient.icon")) {
            String iconUrl = "/filerepo/" + topic.getChildTopics().getString("dm4.files.path");
            this.logger.info("### Retyping a file to an icon (iconUrl=" + iconUrl + ")");
            newModel.setSimpleValue(iconUrl);
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel newModel, TopicModel oldModel) {
        if (topic.getTypeUri().equals("dm4.webclient.view_config")) {
            this.updateType(topic);
            this.setConfigTopicLabel(topic);
        }
    }

    public void introduceTopicType(TopicType topicType) {
        this.setViewConfigLabel(topicType.getViewConfig());
    }

    public void introduceAssociationType(AssociationType assocType) {
        this.setViewConfigLabel(assocType.getViewConfig());
    }

    private Set<Topic> findSearchableUnits(List<? extends Topic> topics) {
        LinkedHashSet<Topic> searchableUnits = new LinkedHashSet<Topic>();
        for (Topic topic : topics) {
            if (this.searchableAsUnit(topic)) {
                searchableUnits.add(topic);
                continue;
            }
            List parentTopics = topic.getRelatedTopics((String)null, "dm4.core.child", "dm4.core.parent", null);
            if (parentTopics.isEmpty()) {
                searchableUnits.add(topic);
                continue;
            }
            searchableUnits.addAll(this.findSearchableUnits(parentTopics));
        }
        return searchableUnits;
    }

    private Topic createSearchTopic(final String searchTerm, final Collection<Topic> resultItems) {
        try {
            return (Topic)this.dm4.getAccessControl().runWithoutWorkspaceAssignment((Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    Topic searchTopic = WebclientPlugin.this.dm4.createTopic(WebclientPlugin.this.mf.newTopicModel("dm4.webclient.search", WebclientPlugin.this.mf.newChildTopicsModel().put("dm4.webclient.search_term", (Object)searchTerm)));
                    for (Topic resultItem : resultItems) {
                        WebclientPlugin.this.dm4.createAssociation(WebclientPlugin.this.mf.newAssociationModel("dm4.webclient.search_result_item", (RoleModel)WebclientPlugin.this.mf.newTopicRoleModel(searchTopic.getId(), "dm4.core.default"), (RoleModel)WebclientPlugin.this.mf.newTopicRoleModel(resultItem.getId(), "dm4.core.default")));
                    }
                    return searchTopic;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating search topic for \"" + searchTerm + "\" failed", e);
        }
    }

    private boolean searchableAsUnit(Topic topic) {
        TopicType topicType = this.dm4.getTopicType(topic.getTypeUri());
        Boolean searchableAsUnit = (Boolean)this.getViewConfig(topicType, "searchable_as_unit");
        return searchableAsUnit != null ? searchableAsUnit : false;
    }

    private Object getViewConfig(TopicType topicType, String setting) {
        return topicType.getViewConfig("dm4.webclient.view_config", "dm4.webclient." + setting);
    }

    private void updateType(Topic viewConfig) {
        RelatedTopic type = viewConfig.getRelatedTopic("dm4.core.aggregation", "dm4.core.view_config", "dm4.core.type", null);
        if (type != null) {
            String typeUri = type.getTypeUri();
            if (typeUri.equals("dm4.core.topic_type") || typeUri.equals("dm4.core.meta_type")) {
                this.updateTopicType((Topic)type, viewConfig);
            } else if (typeUri.equals("dm4.core.assoc_type")) {
                this.updateAssociationType((Topic)type, viewConfig);
            } else {
                throw new RuntimeException("View Configuration " + viewConfig.getId() + " is associated to an " + "unexpected topic (type=" + type + "\nviewConfig=" + viewConfig + ")");
            }
        }
    }

    private void updateTopicType(Topic type, Topic viewConfig) {
        this.logger.info("### Updating view configuration of topic type \"" + type.getUri() + "\" (viewConfig=" + viewConfig + ")");
        TopicType topicType = this.dm4.getTopicType(type.getUri());
        this.updateViewConfig((DeepaMehtaType)topicType, viewConfig);
        Directives.get().add(Directive.UPDATE_TOPIC_TYPE, (JSONEnabled)topicType);
    }

    private void updateAssociationType(Topic type, Topic viewConfig) {
        this.logger.info("### Updating view configuration of association type \"" + type.getUri() + "\" (viewConfig=" + viewConfig + ")");
        AssociationType assocType = this.dm4.getAssociationType(type.getUri());
        this.updateViewConfig((DeepaMehtaType)assocType, viewConfig);
        Directives.get().add(Directive.UPDATE_ASSOCIATION_TYPE, (JSONEnabled)assocType);
    }

    private void updateViewConfig(DeepaMehtaType type, Topic viewConfig) {
        type.getViewConfig().updateConfigTopic(viewConfig.getModel());
    }

    private void setViewConfigLabel(ViewConfiguration viewConfig) {
        for (Topic configTopic : viewConfig.getConfigTopics()) {
            this.setConfigTopicLabel(configTopic);
        }
    }

    private void setConfigTopicLabel(Topic viewConfig) {
        viewConfig.setSimpleValue(VIEW_CONFIG_LABEL);
    }

    private String getWebclientUrl() {
        String port;
        String protocol;
        boolean isHttpsEnabled = Boolean.getBoolean("org.apache.felix.https.enable");
        if (isHttpsEnabled) {
            protocol = "https";
            port = System.getProperty("org.osgi.service.http.port.secure");
        } else {
            protocol = "http";
            port = System.getProperty("org.osgi.service.http.port");
        }
        return protocol + "://localhost:" + port + "/de.deepamehta.webclient/";
    }

    private boolean isDirectModelledChildTopic(RelatedTopic childTopic, Topic parentTopic) {
        Association assoc;
        return this.hasAssocDef(parentTopic, childTopic) && (assoc = childTopic.getRelatingAssociation()).isPlayer(this.mf.newTopicRoleModel(parentTopic.getId(), "dm4.core.parent")) && assoc.isPlayer(this.mf.newTopicRoleModel(childTopic.getId(), "dm4.core.child"));
    }

    private boolean hasAssocDef(Topic parentTopic, RelatedTopic childTopic) {
        TopicType parentType = this.dm4.getTopicType(parentTopic.getTypeUri());
        String childTypeUri = childTopic.getTypeUri();
        String assocTypeUri = childTopic.getRelatingAssociation().getTypeUri();
        String assocDefUri = childTypeUri + "#" + assocTypeUri;
        if (parentType.hasAssocDef(assocDefUri)) {
            return true;
        }
        if (parentType.hasAssocDef(childTypeUri)) {
            return parentType.getAssocDef(childTypeUri).getInstanceLevelAssocTypeUri().equals(assocTypeUri);
        }
        return false;
    }
}

