/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.topicmaps.model;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.plugins.topicmaps.model.AssociationViewmodel;
import de.deepamehta.plugins.topicmaps.model.TopicViewmodel;
import java.awt.Point;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

public class TopicmapViewmodel
implements JSONEnabled {
    private TopicModel topicmapTopic;
    private Map<Long, TopicViewmodel> topics;
    private Map<Long, AssociationViewmodel> assocs;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapViewmodel(TopicModel topicmapTopic, Map<Long, TopicViewmodel> topics, Map<Long, AssociationViewmodel> assocs) {
        this.topicmapTopic = topicmapTopic;
        this.topics = topics;
        this.assocs = assocs;
    }

    public long getId() {
        return this.topicmapTopic.getId();
    }

    public Iterable<TopicViewmodel> getTopics() {
        return this.topics.values();
    }

    public Iterable<AssociationViewmodel> getAssociations() {
        return this.assocs.values();
    }

    public TopicViewmodel getTopic(long id) {
        return this.topics.get(id);
    }

    public AssociationViewmodel getAssociation(long id) {
        return this.assocs.get(id);
    }

    public JSONObject toJSON() {
        try {
            JSONObject topicmap = new JSONObject();
            topicmap.put("info", (Object)this.topicmapTopic.toJSON());
            topicmap.put("topics", (Object)DeepaMehtaUtils.objectsToJSON(this.topics.values()));
            topicmap.put("assocs", (Object)DeepaMehtaUtils.objectsToJSON(this.assocs.values()));
            return topicmap;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public String toString() {
        return "topicmap " + this.getId();
    }

    public class GridPositioning {
        private final int GRID_DIST_X = 220;
        private final int GRID_DIST_Y = 80;
        private final int START_X;
        private final int START_Y = 50;
        private final int MIN_Y = -9999;
        private final int canvasWidth;
        private final int transX;
        private int gridX;
        private int gridY;

        public GridPositioning(int canvasWidth, int transX) {
            this.canvasWidth = canvasWidth;
            this.transX = transX;
            this.START_X = 50 - transX;
            Point startPos = this.findStartPostition();
            this.gridX = startPos.x;
            this.gridY = startPos.y;
        }

        public Point nextPosition() {
            Point pos = new Point(this.gridX, this.gridY);
            this.advancePosition();
            return pos;
        }

        private Point findStartPostition() {
            int maxY = -9999;
            for (TopicViewmodel topic : TopicmapViewmodel.this.topics.values()) {
                if (topic.getY() <= maxY) continue;
                maxY = topic.getY();
            }
            int x = this.START_X;
            int y = maxY != -9999 ? maxY + 80 : 50;
            return new Point(x, y);
        }

        private void advancePosition() {
            if (this.gridX + 220 + this.transX > this.canvasWidth) {
                this.gridX = this.START_X;
                this.gridY += 80;
            } else {
                this.gridX += 220;
            }
        }
    }
}

