/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.topicmaps;

import de.deepamehta.core.Association;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.plugins.topicmaps.ClusterCoords;
import de.deepamehta.plugins.topicmaps.DefaultTopicmapRenderer;
import de.deepamehta.plugins.topicmaps.TopicmapRenderer;
import de.deepamehta.plugins.topicmaps.ViewmodelCustomizer;
import de.deepamehta.plugins.topicmaps.model.AssociationViewmodel;
import de.deepamehta.plugins.topicmaps.model.TopicViewmodel;
import de.deepamehta.plugins.topicmaps.model.TopicmapViewmodel;
import de.deepamehta.plugins.topicmaps.service.TopicmapsService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/topicmap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TopicmapsPlugin
extends PluginActivator
implements TopicmapsService {
    private static final String DEFAULT_TOPICMAP_NAME = "untitled";
    private static final String DEFAULT_TOPICMAP_URI = "dm4.topicmaps.default_topicmap";
    private static final String DEFAULT_TOPICMAP_RENDERER = "dm4.webclient.default_topicmap_renderer";
    private static final String TOPIC_MAPCONTEXT = "dm4.topicmaps.topic_mapcontext";
    private static final String ASSOCIATION_MAPCONTEXT = "dm4.topicmaps.association_mapcontext";
    private static final String ROLE_TYPE_TOPICMAP = "dm4.core.default";
    private static final String ROLE_TYPE_TOPIC = "dm4.topicmaps.topicmap_topic";
    private static final String ROLE_TYPE_ASSOCIATION = "dm4.topicmaps.topicmap_association";
    private Map<String, TopicmapRenderer> topicmapRenderers = new HashMap<String, TopicmapRenderer>();
    private List<ViewmodelCustomizer> viewmodelCustomizers = new ArrayList<ViewmodelCustomizer>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TopicmapsPlugin() {
        this.registerTopicmapRenderer(new DefaultTopicmapRenderer());
    }

    @Override
    @GET
    @Path(value="/{id}")
    public TopicmapViewmodel getTopicmap(@PathParam(value="id") long topicmapId, @QueryParam(value="include_childs") boolean includeChilds) {
        try {
            this.logger.info("Loading topicmap " + topicmapId + " (includeChilds=" + includeChilds + ")");
            Topic topicmapTopic = this.dms.getTopic(topicmapId).loadChildTopics();
            Map<Long, TopicViewmodel> topics = this.fetchTopics(topicmapTopic, includeChilds);
            Map<Long, AssociationViewmodel> assocs = this.fetchAssociations(topicmapTopic);
            return new TopicmapViewmodel(topicmapTopic.getModel(), topics, assocs);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topicmap " + topicmapId + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/{name}/{topicmap_renderer_uri}")
    @Transactional
    public Topic createTopicmap(@PathParam(value="name") String name, @PathParam(value="topicmap_renderer_uri") String topicmapRendererUri) {
        return this.createTopicmap(name, null, topicmapRendererUri);
    }

    @Override
    public Topic createTopicmap(String name, String uri, String topicmapRendererUri) {
        ChildTopicsModel topicmapState = this.getTopicmapRenderer(topicmapRendererUri).initialTopicmapState();
        return this.dms.createTopic(new TopicModel(uri, "dm4.topicmaps.topicmap", new ChildTopicsModel().put("dm4.topicmaps.name", (Object)name).put("dm4.topicmaps.topicmap_renderer_uri", (Object)topicmapRendererUri).put("dm4.topicmaps.state", topicmapState)));
    }

    @Override
    @POST
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void addTopicToTopicmap(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ChildTopicsModel viewProps) {
        try {
            this.dms.createAssociation(new AssociationModel(TOPIC_MAPCONTEXT, (RoleModel)new TopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)new TopicRoleModel(topicId, ROLE_TYPE_TOPIC), viewProps));
            this.storeCustomViewProperties(topicmapId, topicId, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Adding topic " + topicId + " to topicmap " + topicmapId + " failed " + "(viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    public void addTopicToTopicmap(long topicmapId, long topicId, int x, int y, boolean visibility) {
        this.addTopicToTopicmap(topicmapId, topicId, new StandardViewProperties(x, y, visibility));
    }

    @Override
    @POST
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void addAssociationToTopicmap(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId) {
        this.dms.createAssociation(new AssociationModel(ASSOCIATION_MAPCONTEXT, (RoleModel)new TopicRoleModel(topicmapId, ROLE_TYPE_TOPICMAP), (RoleModel)new AssociationRoleModel(assocId, ROLE_TYPE_ASSOCIATION)));
    }

    @Override
    public boolean isTopicInTopicmap(long topicmapId, long topicId) {
        return this.fetchTopicRefAssociation(topicmapId, topicId) != null;
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}")
    @Transactional
    public void setViewProperties(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, ChildTopicsModel viewProps) {
        try {
            this.storeStandardViewProperties(topicmapId, topicId, viewProps);
            this.storeCustomViewProperties(topicmapId, topicId, viewProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Storing view properties of topic " + topicId + " failed " + "(viewProps=" + viewProps + ")", e);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{x}/{y}")
    @Transactional
    public void setTopicPosition(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        this.storeStandardViewProperties(topicmapId, topicId, new StandardViewProperties(x, y));
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{topic_id}/{visibility}")
    @Transactional
    public void setTopicVisibility(@PathParam(value="id") long topicmapId, @PathParam(value="topic_id") long topicId, @PathParam(value="visibility") boolean visibility) {
        this.storeStandardViewProperties(topicmapId, topicId, new StandardViewProperties(visibility));
    }

    @Override
    @DELETE
    @Path(value="/{id}/association/{assoc_id}")
    @Transactional
    public void removeAssociationFromTopicmap(@PathParam(value="id") long topicmapId, @PathParam(value="assoc_id") long assocId) {
        this.fetchAssociationRefAssociation(topicmapId, assocId).delete();
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Transactional
    public void setClusterPosition(@PathParam(value="id") long topicmapId, ClusterCoords coords) {
        for (ClusterCoords.Entry entry : coords) {
            this.setTopicPosition(topicmapId, entry.topicId, entry.x, entry.y);
        }
    }

    @Override
    @PUT
    @Path(value="/{id}/translation/{x}/{y}")
    @Transactional
    public void setTopicmapTranslation(@PathParam(value="id") long topicmapId, @PathParam(value="x") int transX, @PathParam(value="y") int transY) {
        try {
            ChildTopicsModel topicmapState = new ChildTopicsModel().put("dm4.topicmaps.state", new ChildTopicsModel().put("dm4.topicmaps.translation", new ChildTopicsModel().put("dm4.topicmaps.translation_x", (Object)transX).put("dm4.topicmaps.translation_y", (Object)transY)));
            this.dms.updateTopic(new TopicModel(topicmapId, topicmapState));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting translation of topicmap " + topicmapId + " failed (transX=" + transX + ", transY=" + transY + ")", e);
        }
    }

    @Override
    public void registerTopicmapRenderer(TopicmapRenderer renderer) {
        this.logger.info("### Registering topicmap renderer \"" + renderer.getClass().getName() + "\"");
        this.topicmapRenderers.put(renderer.getUri(), renderer);
    }

    @Override
    public void registerViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Registering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        this.viewmodelCustomizers.add(customizer);
    }

    @Override
    public void unregisterViewmodelCustomizer(ViewmodelCustomizer customizer) {
        this.logger.info("### Unregistering viewmodel customizer \"" + customizer.getClass().getName() + "\"");
        if (!this.viewmodelCustomizers.remove(customizer)) {
            throw new RuntimeException("Unregistering viewmodel customizer failed (customizer=" + customizer + ")");
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapInWebclient() {
        return this.invokeWebclient();
    }

    @GET
    @Path(value="/{id}/topic/{topic_id}")
    @Produces(value={"text/html"})
    public InputStream getTopicmapAndTopicInWebclient() {
        return this.invokeWebclient();
    }

    public void postInstall() {
        this.createTopicmap(DEFAULT_TOPICMAP_NAME, DEFAULT_TOPICMAP_URI, DEFAULT_TOPICMAP_RENDERER);
    }

    private Map<Long, TopicViewmodel> fetchTopics(Topic topicmapTopic, boolean includeChilds) {
        HashMap<Long, TopicViewmodel> topics = new HashMap<Long, TopicViewmodel>();
        ResultList relTopics = topicmapTopic.getRelatedTopics(TOPIC_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC, null, 0);
        if (includeChilds) {
            relTopics.loadChildTopics();
        }
        for (RelatedTopic topic : relTopics) {
            Association assoc = topic.getRelatingAssociation().loadChildTopics();
            ChildTopicsModel viewProps = assoc.getChildTopics().getModel();
            this.invokeViewmodelCustomizers("enrichViewProperties", (Topic)topic, viewProps);
            topics.put(topic.getId(), new TopicViewmodel((TopicModel)topic.getModel(), viewProps));
        }
        return topics;
    }

    private Map<Long, AssociationViewmodel> fetchAssociations(Topic topicmapTopic) {
        HashMap<Long, AssociationViewmodel> assocs = new HashMap<Long, AssociationViewmodel>();
        ResultList relAssocs = topicmapTopic.getRelatedAssociations(ASSOCIATION_MAPCONTEXT, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION, null);
        for (RelatedAssociation assoc : relAssocs) {
            assocs.put(assoc.getId(), new AssociationViewmodel((AssociationModel)assoc.getModel()));
        }
        return assocs;
    }

    private Association fetchTopicRefAssociation(long topicmapId, long topicId) {
        return this.dms.getAssociation(TOPIC_MAPCONTEXT, topicmapId, topicId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_TOPIC);
    }

    private Association fetchAssociationRefAssociation(long topicmapId, long assocId) {
        return this.dms.getAssociationBetweenTopicAndAssociation(ASSOCIATION_MAPCONTEXT, topicmapId, assocId, ROLE_TYPE_TOPICMAP, ROLE_TYPE_ASSOCIATION);
    }

    private void storeStandardViewProperties(long topicmapId, long topicId, ChildTopicsModel viewProps) {
        this.fetchTopicRefAssociation(topicmapId, topicId).setChildTopics(viewProps);
    }

    private void storeCustomViewProperties(long topicmapId, long topicId, ChildTopicsModel viewProps) {
        this.invokeViewmodelCustomizers("storeViewProperties", this.dms.getTopic(topicId), viewProps);
    }

    private void invokeViewmodelCustomizers(String method, Topic topic, ChildTopicsModel viewProps) {
        for (ViewmodelCustomizer customizer : this.viewmodelCustomizers) {
            this.invokeViewmodelCustomizer(customizer, method, topic, viewProps);
        }
    }

    private void invokeViewmodelCustomizer(ViewmodelCustomizer customizer, String method, Topic topic, ChildTopicsModel viewProps) {
        block4: {
            try {
                if (method.equals("enrichViewProperties")) {
                    customizer.enrichViewProperties(topic, viewProps);
                    break block4;
                }
                if (method.equals("storeViewProperties")) {
                    customizer.storeViewProperties(topic, viewProps);
                    break block4;
                }
                throw new RuntimeException("\"" + method + "\" is an unexpected method");
            }
            catch (Exception e) {
                throw new RuntimeException("Invoking viewmodel customizer for topic " + topic.getId() + " failed " + "(customizer=\"" + customizer.getClass().getName() + "\", method=\"" + method + "\")", e);
            }
        }
    }

    private TopicmapRenderer getTopicmapRenderer(String rendererUri) {
        TopicmapRenderer renderer = this.topicmapRenderers.get(rendererUri);
        if (renderer == null) {
            throw new RuntimeException("\"" + rendererUri + "\" is an unknown topicmap renderer");
        }
        return renderer;
    }

    private InputStream invokeWebclient() {
        return this.dms.getPlugin("de.deepamehta.webclient").getStaticResource("/web/index.html");
    }

    private class StandardViewProperties
    extends ChildTopicsModel {
        private StandardViewProperties(int x, int y, boolean visibility) {
            this.put(x, y);
            this.put(visibility);
        }

        private StandardViewProperties(int x, int y) {
            this.put(x, y);
        }

        private StandardViewProperties(boolean visibility) {
            this.put(visibility);
        }

        private void put(int x, int y) {
            this.put("dm4.topicmaps.x", x);
            this.put("dm4.topicmaps.y", y);
        }

        private void put(boolean visibility) {
            this.put("dm4.topicmaps.visibility", visibility);
        }
    }
}

