/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.time;

import com.sun.jersey.spi.container.ContainerResponse;
import de.deepamehta.core.Association;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PostUpdateAssociationListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PostUpdateTopicRequestListener;
import de.deepamehta.core.service.event.PreSendAssociationListener;
import de.deepamehta.core.service.event.PreSendTopicListener;
import de.deepamehta.core.service.event.ServiceResponseFilterListener;
import de.deepamehta.plugins.time.service.TimeService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;

@Path(value="/time")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TimePlugin
extends PluginActivator
implements TimeService,
PostCreateTopicListener,
PostCreateAssociationListener,
PostUpdateTopicListener,
PostUpdateTopicRequestListener,
PostUpdateAssociationListener,
PreSendTopicListener,
PreSendAssociationListener,
ServiceResponseFilterListener {
    private static String PROP_URI_CREATED = "dm4.time.created";
    private static String PROP_URI_MODIFIED = "dm4.time.modified";
    private static String HEADER_LAST_MODIFIED = "Last-Modified";
    private DateFormat rfc2822;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public long getCreationTime(DeepaMehtaObject object) {
        return object.hasProperty(PROP_URI_CREATED) ? (Long)object.getProperty(PROP_URI_CREATED) : 0L;
    }

    @Override
    public long getModificationTime(DeepaMehtaObject object) {
        return object.hasProperty(PROP_URI_MODIFIED) ? (Long)object.getProperty(PROP_URI_MODIFIED) : 0L;
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/created")
    public Collection<Topic> getTopicsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dms.getTopicsByPropertyRange(PROP_URI_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/topics/modified")
    public Collection<Topic> getTopicsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dms.getTopicsByPropertyRange(PROP_URI_MODIFIED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/created")
    public Collection<Association> getAssociationsByCreationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dms.getAssociationsByPropertyRange(PROP_URI_CREATED, (Number)from, (Number)to);
    }

    @Override
    @GET
    @Path(value="/from/{from}/to/{to}/assocs/modified")
    public Collection<Association> getAssociationsByModificationTime(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        return this.dms.getAssociationsByPropertyRange(PROP_URI_MODIFIED, (Number)from, (Number)to);
    }

    public void init() {
        this.rfc2822 = DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH);
        this.rfc2822.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        ((SimpleDateFormat)this.rfc2822).applyPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    }

    public void postCreateTopic(Topic topic) {
        this.storeTimestamps((DeepaMehtaObject)topic);
    }

    public void postCreateAssociation(Association assoc) {
        this.storeTimestamps((DeepaMehtaObject)assoc);
    }

    public void postUpdateTopic(Topic topic, TopicModel newModel, TopicModel oldModel) {
        this.storeTimestamp((DeepaMehtaObject)topic);
    }

    public void postUpdateAssociation(Association assoc, AssociationModel oldModel) {
        this.storeTimestamp((DeepaMehtaObject)assoc);
    }

    public void postUpdateTopicRequest(Topic topic) {
        this.storeParentsTimestamp(topic);
    }

    public void preSendTopic(Topic topic) {
        this.enrichWithTimestamp((DeepaMehtaObject)topic);
    }

    public void preSendAssociation(Association assoc) {
        this.enrichWithTimestamp((DeepaMehtaObject)assoc);
    }

    public void serviceResponseFilter(ContainerResponse response) {
        DeepaMehtaObject object = this.responseObject(response);
        if (object != null) {
            long modified = this.enrichWithTimestamp(object);
            this.setLastModifiedHeader(response, modified);
        }
    }

    private void storeTimestamps(DeepaMehtaObject object) {
        long time = System.currentTimeMillis();
        this.storeCreationTime(object, time);
        this.storeModificationTime(object, time);
    }

    private void storeTimestamp(DeepaMehtaObject object) {
        long time = System.currentTimeMillis();
        this.storeModificationTime(object, time);
    }

    private void storeParentsTimestamp(Topic topic) {
        for (DeepaMehtaObject object : this.getParents(topic)) {
            this.storeTimestamp(object);
        }
    }

    private void storeCreationTime(DeepaMehtaObject object, long time) {
        this.storeTime(object, PROP_URI_CREATED, time);
    }

    private void storeModificationTime(DeepaMehtaObject object, long time) {
        this.storeTime(object, PROP_URI_MODIFIED, time);
    }

    private void storeTime(DeepaMehtaObject object, String propUri, long time) {
        object.setProperty(propUri, (Object)time, true);
    }

    private DeepaMehtaObject responseObject(ContainerResponse response) {
        Object entity = response.getEntity();
        return entity instanceof DeepaMehtaObject ? (DeepaMehtaObject)entity : null;
    }

    private long enrichWithTimestamp(DeepaMehtaObject object) {
        long created = this.getCreationTime(object);
        long modified = this.getModificationTime(object);
        ChildTopicsModel childTopics = object.getChildTopics().getModel();
        childTopics.put(PROP_URI_CREATED, (Object)created);
        childTopics.put(PROP_URI_MODIFIED, (Object)modified);
        return modified;
    }

    private void setLastModifiedHeader(ContainerResponse response, long time) {
        this.setHeader(response, HEADER_LAST_MODIFIED, this.rfc2822.format(time));
    }

    private void setHeader(ContainerResponse response, String header, String value) {
        MultivaluedMap headers = response.getHttpHeaders();
        if (headers.containsKey((Object)header)) {
            throw new RuntimeException("Response already has a \"" + header + "\" header");
        }
        headers.putSingle((Object)header, (Object)value);
    }

    private Set<DeepaMehtaObject> getParents(Topic topic) {
        LinkedHashSet<DeepaMehtaObject> parents = new LinkedHashSet<DeepaMehtaObject>();
        List parentTopics = topic.getRelatedTopics((String)null, "dm4.core.child", "dm4.core.parent", null, 0).getItems();
        List parentAssocs = topic.getRelatedAssociations(null, "dm4.core.child", "dm4.core.parent", null).getItems();
        parents.addAll(parentTopics);
        parents.addAll(parentAssocs);
        for (Topic parentTopic : parentTopics) {
            parents.addAll(this.getParents(parentTopic));
        }
        return parents;
    }
}

