/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.storage.neo4j;

import de.deepamehta.core.storage.spi.DeepaMehtaStorage;
import de.deepamehta.storage.neo4j.Neo4jStorage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Neo4jStorageActivator
implements BundleActivator {
    private static final String DATABASE_PATH = System.getProperty("dm4.database.path", "deepamehta-db");
    private DeepaMehtaStorage storage;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext context) {
        try {
            this.logger.info("========== Starting \"DeepaMehta 4 Storage - Neo4j\" ==========");
            this.storage = new Neo4jStorage(DATABASE_PATH);
            this.logger.info("Registering DeepaMehta 4 storage service - Neo4j - at OSGi framework");
            context.registerService(DeepaMehtaStorage.class.getName(), (Object)this.storage, null);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while starting \"DeepaMehta 4 Storage - Neo4j\":", e);
        }
    }

    public void stop(BundleContext context) {
        try {
            this.logger.info("========== Stopping \"DeepaMehta 4 Storage - Neo4j\" ==========");
            if (this.storage != null) {
                this.storage.shutdown();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while stopping \"DeepaMehta 4 Storage - Neo4j\":", e);
        }
    }
}

