/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.geomaps;

import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Cookies;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PreSendTopicListener;
import de.deepamehta.core.util.ContextTracker;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.facets.FacetsService;
import de.deepamehta.geomaps.GeomapRenderer;
import de.deepamehta.geomaps.GeomapsService;
import de.deepamehta.geomaps.model.GeoCoordinate;
import de.deepamehta.geomaps.model.Geomap;
import de.deepamehta.topicmaps.TopicmapRenderer;
import de.deepamehta.topicmaps.TopicmapsService;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/geomap")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GeomapsPlugin
extends PluginActivator
implements GeomapsService,
PostCreateTopicListener,
PostUpdateTopicListener,
PreSendTopicListener {
    private static final String GEOCODER_URL = "http://maps.googleapis.com/maps/api/geocode/json?address=%s&sensor=false";
    private static final String COOKIE_NO_GEOCODING = "dm4_no_geocoding";
    private static final double EARTH_RADIUS_KM = 6371.009;
    @Inject
    private TopicmapsService topicmapsService;
    @Inject
    private FacetsService facetsService;
    private ContextTracker contextTracker = new ContextTracker();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{id}")
    public Geomap getGeomap(@PathParam(value="id") long geomapId) {
        return new Geomap(geomapId, this.dm4);
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Topic getDomainTopic(@PathParam(value="id") long geoCoordId) {
        try {
            RelatedTopic parentTopic;
            Topic topic = this.dm4.getTopic(geoCoordId);
            while ((parentTopic = topic.getRelatedTopic(null, "dm4.core.child", "dm4.core.parent", null)) != null) {
                topic = parentTopic;
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Finding the geo coordinate's domain topic failed (geoCoordId=" + geoCoordId + ")", e);
        }
    }

    @Override
    public GeoCoordinate getGeoCoordinate(Topic geoTopic) {
        try {
            Topic geoCoordTopic = this.getGeoCoordinateTopic(geoTopic);
            if (geoCoordTopic != null) {
                return this.geoCoordinate(geoCoordTopic);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the geo coordinate failed (geoTopic=" + geoTopic + ")", e);
        }
    }

    @Override
    public GeoCoordinate geoCoordinate(Topic geoCoordTopic) {
        ChildTopics childTopics = geoCoordTopic.getChildTopics();
        return new GeoCoordinate(childTopics.getDouble("dm4.geomaps.longitude"), childTopics.getDouble("dm4.geomaps.latitude"));
    }

    @Override
    @PUT
    @Path(value="/{id}/topic/{geo_coord_id}")
    @Transactional
    public void addCoordinateToGeomap(@PathParam(value="id") long geomapId, @PathParam(value="geo_coord_id") long geoCoordId) {
        this.logger.info("### Adding geo coordinate topic " + geoCoordId + " to geomap " + geomapId);
        AssociationModel model = this.mf.newAssociationModel("dm4.geomaps.geotopic_mapcontext", (RoleModel)this.mf.newTopicRoleModel(geomapId, "dm4.core.default"), (RoleModel)this.mf.newTopicRoleModel(geoCoordId, "dm4.topicmaps.topicmap_topic"));
        this.dm4.createAssociation(model);
    }

    @Override
    @PUT
    @Path(value="/{id}/center/{lon}/{lat}/zoom/{zoom}")
    @Transactional
    public void setGeomapState(@PathParam(value="id") long geomapId, @PathParam(value="lon") double lon, @PathParam(value="lat") double lat, @PathParam(value="zoom") int zoom) {
        ChildTopicsModel geomapState = this.mf.newChildTopicsModel().put("dm4.topicmaps.state", this.mf.newChildTopicsModel().put("dm4.topicmaps.translation", this.mf.newChildTopicsModel().put("dm4.topicmaps.translation_x", (Object)lon).put("dm4.topicmaps.translation_y", (Object)lat)).put("dm4.topicmaps.zoom_level", (Object)zoom));
        this.dm4.updateTopic(this.mf.newTopicModel(geomapId, geomapState));
    }

    @Override
    @GET
    @Path(value="/distance")
    public double getDistance(@QueryParam(value="coord1") GeoCoordinate coord1, @QueryParam(value="coord2") GeoCoordinate coord2) {
        double lonDiff = Math.toRadians(coord2.lon - coord1.lon);
        double latDiff = Math.toRadians(coord2.lat - coord1.lat);
        double latMean = Math.toRadians((coord1.lat + coord2.lat) / 2.0);
        return 6371.009 * Math.sqrt(Math.pow(latDiff, 2.0) + Math.pow(Math.cos(latMean) * lonDiff, 2.0));
    }

    @Override
    public <V> V runWithoutGeocoding(Callable<V> callable) throws Exception {
        return (V)this.contextTracker.run(callable);
    }

    public void init() {
        this.topicmapsService.registerTopicmapRenderer((TopicmapRenderer)new GeomapRenderer());
    }

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dm4.contacts.address") && !this.abortGeocoding(topic)) {
            this.facetsService.addFacetTypeToTopic(topic.getId(), "dm4.geomaps.geo_coordinate_facet");
            Address address = new Address(topic.getChildTopics().getModel());
            if (!address.isEmpty()) {
                this.logger.info("### New " + address);
                this.geocodeAndStoreFacet(address, topic);
            } else {
                this.logger.info("### New empty address");
            }
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel newModel, TopicModel oldModel) {
        if (topic.getTypeUri().equals("dm4.contacts.address") && !this.abortGeocoding(topic)) {
            Address oldAddress;
            Address address = new Address(topic.getChildTopics().getModel());
            if (!address.equals(oldAddress = new Address(oldModel.getChildTopicsModel()))) {
                this.logger.info("### Address changed:" + address.changeReport(oldAddress));
                this.geocodeAndStoreFacet(address, topic);
            } else {
                this.logger.info("### Address not changed");
            }
        }
    }

    public void preSendTopic(Topic topic) {
        Topic address = topic.findChildTopic("dm4.contacts.address");
        if (address != null) {
            String operation = "### Enriching address " + address.getId() + " with its geo coordinate";
            Topic geoCoordTopic = this.getGeoCoordinateTopic(address);
            if (geoCoordTopic != null) {
                this.logger.info(operation);
                address.getChildTopics().getModel().put("dm4.geomaps.geo_coordinate", geoCoordTopic.getModel());
            } else {
                this.logger.info(operation + " ABORTED -- no geo coordinate in DB");
            }
        }
    }

    private Topic getGeoCoordinateTopic(Topic geoTopic) {
        RelatedTopic geoCoordTopic = this.facetsService.getFacet((DeepaMehtaObject)geoTopic, "dm4.geomaps.geo_coordinate_facet");
        return geoCoordTopic != null ? geoCoordTopic.loadChildTopics() : null;
    }

    private void geocodeAndStoreFacet(Address address, Topic topic) {
        try {
            GeoCoordinate geoCoord = address.geocode();
            this.storeGeoCoordinate(topic, geoCoord);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Adding geo coordinate to " + address + " failed", e);
        }
    }

    private void storeGeoCoordinate(Topic address, GeoCoordinate geoCoord) {
        try {
            this.logger.info("Storing geo coordinate (" + geoCoord + ") of address " + address);
            this.facetsService.updateFacet((DeepaMehtaObject)address, "dm4.geomaps.geo_coordinate_facet", this.mf.newFacetValueModel("dm4.geomaps.geo_coordinate").put(this.mf.newChildTopicsModel().put("dm4.geomaps.longitude", (Object)geoCoord.lon).put("dm4.geomaps.latitude", (Object)geoCoord.lat)));
        }
        catch (Exception e) {
            throw new RuntimeException("Storing geo coordinate of address " + address.getId() + " failed", e);
        }
    }

    private boolean abortGeocoding(Topic address) {
        return this.abortGeocodingByCookie(address) || this.abortGeocodingByExcecutionContext(address);
    }

    private boolean abortGeocodingByCookie(Topic address) {
        boolean abort = false;
        Cookies cookies = Cookies.get();
        if (cookies.has(COOKIE_NO_GEOCODING)) {
            String value = cookies.get(COOKIE_NO_GEOCODING);
            if (!value.equals("false") && !value.equals("true")) {
                throw new RuntimeException("\"" + value + "\" is an unexpected value for the \"" + COOKIE_NO_GEOCODING + "\" cookie (expected are \"false\" or \"true\")");
            }
            abort = value.equals("true");
            if (abort) {
                this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- \"" + COOKIE_NO_GEOCODING + "\" cookie detected");
            }
        }
        return abort;
    }

    private boolean abortGeocodingByExcecutionContext(Topic address) {
        boolean abort = this.contextTracker.runsInTrackedContext();
        if (abort) {
            this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- runWithoutGeocoding() context detected");
        }
        return abort;
    }

    private class Address {
        String street;
        String postalCode;
        String city;
        String country;

        Address(ChildTopicsModel address) {
            this.street = address.getString("dm4.contacts.street", "");
            this.postalCode = address.getString("dm4.contacts.postal_code", "");
            this.city = address.getString("dm4.contacts.city", "");
            this.country = address.getString("dm4.contacts.country", "");
        }

        GeoCoordinate geocode() {
            URL url = null;
            try {
                String address = this.street + ", " + this.postalCode + " " + this.city + ", " + this.country;
                url = new URL(String.format(GeomapsPlugin.GEOCODER_URL, JavaUtils.encodeURIComponent((String)address)));
                GeomapsPlugin.this.logger.info("### Geocoding \"" + address + "\"\n    url=\"" + url + "\"");
                JSONObject response = new JSONObject(JavaUtils.readTextURL((URL)url));
                String status = response.getString("status");
                if (!status.equals("OK")) {
                    throw new RuntimeException(status);
                }
                JSONObject location = response.getJSONArray("results").getJSONObject(0).getJSONObject("geometry").getJSONObject("location");
                double lng = location.getDouble("lng");
                double lat = location.getDouble("lat");
                GeoCoordinate geoCoord = new GeoCoordinate(lng, lat);
                GeomapsPlugin.this.logger.info("=> " + geoCoord);
                return geoCoord;
            }
            catch (Exception e) {
                throw new RuntimeException("Geocoding failed (url=\"" + url + "\")", e);
            }
        }

        boolean isEmpty() {
            return this.street.equals("") && this.postalCode.equals("") && this.city.equals("") && this.country.equals("");
        }

        String changeReport(Address oldAddr) {
            StringBuilder report = new StringBuilder();
            if (!this.street.equals(oldAddr.street)) {
                report.append("\n    Street: \"" + oldAddr.street + "\" -> \"" + this.street + "\"");
            }
            if (!this.postalCode.equals(oldAddr.postalCode)) {
                report.append("\n    Postal Code: \"" + oldAddr.postalCode + "\" -> \"" + this.postalCode + "\"");
            }
            if (!this.city.equals(oldAddr.city)) {
                report.append("\n    City: \"" + oldAddr.city + "\" -> \"" + this.city + "\"");
            }
            if (!this.country.equals(oldAddr.country)) {
                report.append("\n    Country: \"" + oldAddr.country + "\" -> \"" + this.country + "\"");
            }
            return report.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Address) {
                Address addr = (Address)o;
                return this.street.equals(addr.street) && this.postalCode.equals(addr.postalCode) && this.city.equals(addr.city) && this.country.equals(addr.country);
            }
            return false;
        }

        public int hashCode() {
            return (this.street + this.postalCode + this.city + this.country).hashCode();
        }

        public String toString() {
            return "address (street=\"" + this.street + "\", postalCode=\"" + this.postalCode + "\", city=\"" + this.city + "\", country=\"" + this.country + "\")";
        }
    }
}

