/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.geomaps.model;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.DeepaMehtaService;
import de.deepamehta.core.service.ResultList;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

public class Geomap
implements Iterable<TopicModel>,
JSONEnabled {
    protected Topic geomapTopic;
    protected Map<Long, TopicModel> geoCoords = new HashMap<Long, TopicModel>();
    protected DeepaMehtaService dms;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Geomap(long geomapId, DeepaMehtaService dms) {
        this.logger.info("Loading geomap " + geomapId);
        this.geomapTopic = dms.getTopic(geomapId).loadChildTopics();
        this.dms = dms;
        this.fetchGeoCoordinates();
    }

    public long getId() {
        return this.geomapTopic.getId();
    }

    public boolean containsTopic(long geoCoordId) {
        return this.geoCoords.get(geoCoordId) != null;
    }

    public JSONObject toJSON() {
        try {
            JSONObject topicmap = new JSONObject();
            topicmap.put("info", (Object)this.geomapTopic.toJSON());
            topicmap.put("topics", (Object)DeepaMehtaUtils.objectsToJSON(this.geoCoords.values()));
            return topicmap;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public Iterator<TopicModel> iterator() {
        return this.geoCoords.values().iterator();
    }

    public String toString() {
        return "geomap " + this.getId();
    }

    private void fetchGeoCoordinates() {
        for (RelatedTopic geoCoord : this.fetchGeoCoordinates(this.geomapTopic)) {
            this.geoCoords.put(geoCoord.getId(), geoCoord.getModel());
        }
    }

    private ResultList<RelatedTopic> fetchGeoCoordinates(Topic geomapTopic) {
        return geomapTopic.getRelatedTopics("dm4.geomaps.geotopic_mapcontext", "dm4.core.default", "dm4.topicmaps.topicmap_topic", "dm4.geomaps.geo_coordinate", 0).loadChildTopics();
    }
}

