/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.files.migrations;

import de.deepamehta.core.Topic;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.service.Migration;
import java.util.List;
import java.util.logging.Logger;

public class Migration4
extends Migration {
    private static final boolean FILE_REPOSITORY_PER_WORKSPACE = Boolean.getBoolean("dm4.filerepo.per_workspace");
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        if (FILE_REPOSITORY_PER_WORKSPACE) {
            List workspaces = this.dm4.getTopicsByType("dm4.workspaces.workspace");
            this.logger.info("########## Renaming root Folder topics of " + workspaces.size() + " possible workspaces");
            int renamed = 0;
            for (Topic workspace : workspaces) {
                Topic folderTopic = this.fetchFolderTopic("/workspace-" + workspace.getId());
                if (folderTopic == null) continue;
                folderTopic.getChildTopics().set("dm4.files.folder_name", (Object)workspace.getSimpleValue().toString());
                ++renamed;
            }
            this.logger.info("########## Root Folder topics renamed: " + renamed);
        } else {
            this.logger.info("########## Renaming root Folder topics SKIPPED -- per-workspace file repositories are switched off");
        }
        this.dm4.getTopicType("dm4.files.disk_quota").setSimpleValue("Disk Quota (MB)");
        this.setTopicTypeViewConfigValue("dm4.files.size", "simple_renderer_uri", "dm4.files.file_size_renderer");
    }

    private Topic fetchFolderTopic(String repoPath) {
        Topic topic = this.dm4.getTopicByValue("dm4.files.path", new SimpleValue(repoPath));
        return topic != null ? topic.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", "dm4.files.folder") : null;
    }
}

