/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.files.provider;

import de.deepamehta.plugins.files.UploadedFile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@Provider
public class UploadedFileProvider
implements MessageBodyReader<UploadedFile> {
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == UploadedFile.class && mediaType.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    public UploadedFile readFrom(Class<UploadedFile> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.parseMultiPart();
        }
        catch (Exception e) {
            throw new RuntimeException("Creating UploadedFile from message body failed", e);
        }
    }

    private UploadedFile parseMultiPart() {
        try {
            UploadedFile file = null;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(this.request);
            this.logger.info("### Parsing multipart/form-data request (" + items.size() + " parts)");
            for (FileItem item : items) {
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    String value = item.getString();
                    this.logger.info("### field \"" + fieldName + "\" => \"" + value + "\"");
                    throw new RuntimeException("\"" + fieldName + "\" is an unexpected field (value=\"" + value + "\")");
                }
                if (file != null) {
                    throw new RuntimeException("Only single file uploads are supported");
                }
                file = new UploadedFile(item);
                this.logger.info("### field \"" + fieldName + "\" => " + file);
            }
            if (file == null) {
                throw new RuntimeException("Request does not contain a file part");
            }
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing multipart/form-data request failed", e);
        }
    }
}

