/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.files;

import de.deepamehta.core.Topic;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.SecurityHandler;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.plugins.files.DirectoryListing;
import de.deepamehta.plugins.files.FileRepositoryException;
import de.deepamehta.plugins.files.ResourceInfo;
import de.deepamehta.plugins.files.StoredFile;
import de.deepamehta.plugins.files.UploadedFile;
import de.deepamehta.plugins.files.service.FilesService;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

@Path(value="/files")
@Produces(value={"application/json"})
public class FilesPlugin
extends PluginActivator
implements FilesService,
SecurityHandler {
    private static final String FILE_REPOSITORY_PATH = System.getProperty("dm4.filerepo.path", "");
    private static final String FILE_REPOSITORY_URI = "/filerepo";
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/file/{path:.+}")
    @Transactional
    public Topic createFileTopic(@PathParam(value="path") String path) {
        String operation = "Creating file topic for repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            path = JavaUtils.stripDriveLetter((String)path);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            Topic fileTopic = this.fetchFileTopic(file);
            if (fileTopic != null) {
                this.logger.info(operation + " ABORTED -- already exists");
                return fileTopic;
            }
            return this.createFileTopic(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/folder/{path:.+}")
    @Transactional
    public Topic createFolderTopic(@PathParam(value="path") String path) {
        String operation = "Creating folder topic for repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            path = JavaUtils.stripDriveLetter((String)path);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            Topic folderTopic = this.fetchFolderTopic(file);
            if (folderTopic != null) {
                this.logger.info(operation + " ABORTED -- already exists");
                return folderTopic;
            }
            return this.createFolderTopic(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/parent/{id}/file/{path:.+}")
    @Transactional
    public Topic createChildFileTopic(@PathParam(value="id") long folderTopicId, @PathParam(value="path") String path) {
        Topic childTopic = this.createFileTopic(path);
        this.associateChildTopic(folderTopicId, childTopic.getId());
        return childTopic;
    }

    @Override
    @POST
    @Path(value="/parent/{id}/folder/{path:.+}")
    @Transactional
    public Topic createChildFolderTopic(@PathParam(value="id") long folderTopicId, @PathParam(value="path") String path) {
        Topic childTopic = this.createFolderTopic(path);
        this.associateChildTopic(folderTopicId, childTopic.getId());
        return childTopic;
    }

    @Override
    @POST
    @Path(value="/{path:.+}")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public StoredFile storeFile(UploadedFile file, @PathParam(value="path") String path) {
        String operation = "Storing " + file + " at repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            File directory = this.enforeSecurity(path);
            this.checkFileExistence(directory);
            File repoFile = this.repoFile(directory, file);
            file.write(repoFile);
            Topic fileTopic = this.createFileTopic(repoFile);
            return new StoredFile(repoFile.getName(), fileTopic.getId());
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public Topic createFile(InputStream in, String path) {
        String operation = "Creating file (from input stream) at repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            File file = this.enforeSecurity(path);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            return this.createFileTopic(path);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/{path:.+}/folder/{folder_name}")
    public void createFolder(@PathParam(value="folder_name") String folderName, @PathParam(value="path") String path) {
        String operation = "Creating folder \"" + folderName + "\" at repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            File directory = this.enforeSecurity(path);
            this.checkFileExistence(directory);
            File repoFile = this.repoFile(directory, folderName);
            if (repoFile.exists()) {
                throw new RuntimeException("File or directory \"" + repoFile + "\" already exists");
            }
            boolean success = repoFile.mkdir();
            if (!success) {
                throw new RuntimeException("File.mkdir() failed (file=\"" + repoFile + "\")");
            }
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{path:.+}/info")
    public ResourceInfo getResourceInfo(@PathParam(value="path") String path) {
        String operation = "Getting resource info for repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            return new ResourceInfo(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{path:.+}")
    public DirectoryListing getDirectoryListing(@PathParam(value="path") String path) {
        String operation = "Getting directory listing for repository path \"" + path + "\"";
        try {
            this.logger.info(operation);
            File folder = this.enforeSecurity(path);
            this.checkFileExistence(folder);
            return new DirectoryListing(folder);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public String getRepositoryPath(URL url) {
        String operation = "Checking for file repository URL (\"" + url + "\")";
        try {
            if (!DeepaMehtaUtils.isDeepaMehtaURL((URL)url)) {
                this.logger.info(operation + " => null");
                return null;
            }
            String path = url.getPath();
            if (!path.startsWith(FILE_REPOSITORY_URI)) {
                this.logger.info(operation + " => null");
                return null;
            }
            String repoPath = path.substring(FILE_REPOSITORY_URI.length());
            this.logger.info(operation + " => \"" + repoPath + "\"");
            return repoPath;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public File getFile(String path) {
        String operation = "Accessing the file at \"" + path + "\"";
        try {
            this.logger.info(operation);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    public File getFile(long fileTopicId) {
        String operation = "Accessing the file of file topic " + fileTopicId;
        try {
            this.logger.info(operation);
            String path = this.repoPath(fileTopicId);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/open/{id}")
    public void openFile(@PathParam(value="id") long fileTopicId) {
        String operation = "Opening the file of file topic " + fileTopicId;
        try {
            this.logger.info(operation);
            String path = this.repoPath(fileTopicId);
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            this.logger.info("### Opening file \"" + file + "\"");
            Desktop.getDesktop().open(file);
        }
        catch (FileRepositoryException e) {
            throw new WebApplicationException((Throwable)new RuntimeException(operation + " failed", e), e.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        try {
            String path = request.getRequestURI().substring(FILE_REPOSITORY_URI.length());
            path = JavaUtils.decodeURIComponent((String)path);
            this.logger.info("### repository path=\"" + path + "\"");
            File file = this.enforeSecurity(path);
            this.checkFileExistence(file);
            return true;
        }
        catch (FileRepositoryException e) {
            response.setStatus(e.getStatusCode());
            return false;
        }
        catch (Exception e) {
            response.setStatus(500);
            return false;
        }
    }

    public void init() {
        this.publishDirectory(FILE_REPOSITORY_PATH, FILE_REPOSITORY_URI, this);
    }

    private Topic fetchFileTopic(File file) {
        return this.fetchTopic(file, "dm4.files.file");
    }

    private Topic fetchFolderTopic(File file) {
        return this.fetchTopic(file, "dm4.files.folder");
    }

    private Topic fetchTopic(File file, String parentTypeUri) {
        String path = this.repoPath(file);
        Topic topic = this.dms.getTopic("dm4.files.path", new SimpleValue(path));
        if (topic != null) {
            return topic.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", parentTypeUri);
        }
        return null;
    }

    private Topic createFileTopic(File file) {
        String mediaType = JavaUtils.getFileType((String)file.getName());
        ChildTopicsModel childTopics = new ChildTopicsModel();
        childTopics.put("dm4.files.file_name", (Object)file.getName());
        childTopics.put("dm4.files.path", (Object)this.repoPath(file));
        if (mediaType != null) {
            childTopics.put("dm4.files.media_type", (Object)mediaType);
        }
        childTopics.put("dm4.files.size", (Object)file.length());
        return this.dms.createTopic(new TopicModel("dm4.files.file", childTopics));
    }

    private Topic createFolderTopic(File file) {
        String folderName = file.getName();
        String path = this.repoPath(file);
        if (path.equals("/")) {
            folderName = "";
        }
        ChildTopicsModel childTopics = new ChildTopicsModel();
        childTopics.put("dm4.files.folder_name", (Object)folderName);
        childTopics.put("dm4.files.path", (Object)path);
        return this.dms.createTopic(new TopicModel("dm4.files.folder", childTopics));
    }

    private void associateChildTopic(long folderTopicId, long childTopicId) {
        if (!this.childAssociationExists(folderTopicId, childTopicId)) {
            this.dms.createAssociation(new AssociationModel("dm4.core.aggregation", (RoleModel)new TopicRoleModel(folderTopicId, "dm4.core.parent"), (RoleModel)new TopicRoleModel(childTopicId, "dm4.core.child")));
        }
    }

    private boolean childAssociationExists(long folderTopicId, long childTopicId) {
        return this.dms.getAssociations(folderTopicId, childTopicId, "dm4.core.aggregation").size() > 0;
    }

    private File repoFile(String path) {
        return new File(FILE_REPOSITORY_PATH, path);
    }

    private File repoFile(File directory, UploadedFile file) {
        return JavaUtils.findUnusedFile((File)this.repoFile(directory, file.getName()));
    }

    private File repoFile(File directory, String fileName) {
        return new File(directory, fileName);
    }

    private String repoPath(File file) {
        String path = file.getPath().substring(FILE_REPOSITORY_PATH.length());
        if (path.equals("")) {
            path = "/";
        }
        return path;
    }

    private String repoPath(long fileTopicId) {
        Topic fileTopic = this.dms.getTopic(fileTopicId);
        return fileTopic.getChildTopics().getString("dm4.files.path");
    }

    private File enforeSecurity(String path) throws FileRepositoryException {
        try {
            File file = this.repoFile(path).getCanonicalFile();
            this.checkFilePath(file);
            return file;
        }
        catch (FileRepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Enforcing security for repository path \"" + path + "\" failed", e);
        }
    }

    private void checkFilePath(File file) throws FileRepositoryException {
        boolean pointsToRepository = file.getPath().startsWith(FILE_REPOSITORY_PATH);
        this.logger.info("Checking file repository access to \"" + file + "\"\n      dm4.filerepo.path=" + "\"" + FILE_REPOSITORY_PATH + "\" => " + (pointsToRepository ? "ALLOWED" : "FORBIDDEN"));
        if (!pointsToRepository) {
            throw new FileRepositoryException("\"" + file + "\" is not a file repository path", Response.Status.FORBIDDEN);
        }
    }

    private void checkFileExistence(File file) throws FileRepositoryException {
        if (!file.exists()) {
            this.logger.info("File or directory \"" + file + "\" does not exist => NOT FOUND");
            throw new FileRepositoryException("\"" + file + "\" does not exist in file repository", Response.Status.NOT_FOUND);
        }
    }
}

