/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.files;

import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.plugins.files.ItemKind;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class DirectoryListing
implements JSONEnabled {
    private static final String FILE_REPOSITORY_PATH = System.getProperty("dm4.filerepo.path", "");
    private FileItem dirInfo;
    private List<FileItem> fileItems = new ArrayList<FileItem>();

    public DirectoryListing(File directory) {
        this.dirInfo = new FileItem(directory.getName(), directory.getPath());
        for (File file : directory.listFiles()) {
            String name = file.getName();
            String path = file.getPath();
            if (file.isDirectory()) {
                this.fileItems.add(new FileItem(name, path));
                continue;
            }
            this.fileItems.add(new FileItem(name, path, file.length(), JavaUtils.getFileType((String)file.getName())));
        }
    }

    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    public JSONObject toJSON() {
        try {
            JSONObject dir = this.dirInfo.toJSON();
            JSONArray items = new JSONArray();
            for (FileItem item : this.fileItems) {
                items.put((Object)item.toJSON());
            }
            dir.put("items", (Object)items);
            return dir;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public class FileItem
    implements JSONEnabled {
        ItemKind kind;
        String name;
        String path;
        long size;
        String type;

        FileItem(String name, String path) {
            this.kind = ItemKind.DIRECTORY;
            this.name = name;
            this.path = this.truncate(path);
        }

        FileItem(String name, String path, long size, String type) {
            this.kind = ItemKind.FILE;
            this.name = name;
            this.path = this.truncate(path);
            this.size = size;
            this.type = type;
        }

        public ItemKind getItemKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public String getMediaType() {
            return this.type;
        }

        private String truncate(String path) {
            if (!path.startsWith(FILE_REPOSITORY_PATH)) {
                throw new RuntimeException("Path \"" + path + "\" is not a file repository path");
            }
            return JavaUtils.stripDriveLetter((String)path.substring(FILE_REPOSITORY_PATH.length()));
        }

        public JSONObject toJSON() {
            try {
                JSONObject item = new JSONObject();
                item.put("kind", (Object)this.kind.stringify());
                item.put("name", (Object)this.name);
                item.put("path", (Object)this.path);
                if (this.kind.equals("file")) {
                    item.put("size", this.size);
                    item.put("type", (Object)this.type);
                }
                return item;
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed (" + this + ")", e);
            }
        }
    }
}

