/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.facets;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.facets.FacetValueModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.facets.FacetsService;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/facet")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FacetsPlugin
extends PluginActivator
implements FacetsService {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{facet_type_uri}/topic/{id}")
    public RelatedTopic getFacet(@PathParam(value="id") long topicId, @PathParam(value="facet_type_uri") String facetTypeUri) {
        return this.getFacet((DeepaMehtaObject)this.dm4.getTopic(topicId), facetTypeUri);
    }

    @Override
    public RelatedTopic getFacet(DeepaMehtaObject object, String facetTypeUri) {
        return this.fetchChildTopic(object, this.getAssocDef(facetTypeUri));
    }

    @Override
    @GET
    @Path(value="/multi/{facet_type_uri}/topic/{id}")
    public List<RelatedTopic> getFacets(@PathParam(value="id") long topicId, @PathParam(value="facet_type_uri") String facetTypeUri) {
        return this.getFacets((DeepaMehtaObject)this.dm4.getTopic(topicId), facetTypeUri);
    }

    @Override
    public List<RelatedTopic> getFacets(DeepaMehtaObject object, String facetTypeUri) {
        return this.fetchChildTopics(object, this.getAssocDef(facetTypeUri));
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Topic getFacettedTopic(@PathParam(value="id") long topicId, @QueryParam(value="facet_type_uri") List<String> facetTypeUris) {
        try {
            Topic topic = this.dm4.getTopic(topicId);
            ChildTopicsModel childTopics = topic.getChildTopics().getModel();
            for (String facetTypeUri : facetTypeUris) {
                String childTypeUri = this.getChildTypeUri(facetTypeUri);
                if (!this.isMultiFacet(facetTypeUri)) {
                    RelatedTopic value = this.getFacet((DeepaMehtaObject)topic, facetTypeUri);
                    if (value == null) continue;
                    childTopics.put(childTypeUri, value.getModel());
                    continue;
                }
                List<RelatedTopic> values = this.getFacets((DeepaMehtaObject)topic, facetTypeUri);
                childTopics.put(childTypeUri, DeepaMehtaUtils.toModelList(values));
            }
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting facetted topic " + topicId + " failed (facetTypeUris=" + facetTypeUris + ")", e);
        }
    }

    @Override
    @POST
    @Path(value="/{facet_type_uri}/topic/{id}")
    @Transactional
    public void addFacetTypeToTopic(@PathParam(value="id") long topicId, @PathParam(value="facet_type_uri") String facetTypeUri) {
        this.dm4.createAssociation(this.mf.newAssociationModel("dm4.core.instantiation", (RoleModel)this.mf.newTopicRoleModel(topicId, "dm4.core.instance"), (RoleModel)this.mf.newTopicRoleModel(facetTypeUri, "dm4.facets.facet")));
    }

    @Override
    @PUT
    @Path(value="/{facet_type_uri}/topic/{id}")
    @Transactional
    public void updateFacet(@PathParam(value="id") long topicId, @PathParam(value="facet_type_uri") String facetTypeUri, FacetValueModel value) {
        try {
            this.updateFacet((DeepaMehtaObject)this.dm4.getTopic(topicId), facetTypeUri, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating facet \"" + facetTypeUri + "\" of topic " + topicId + " failed (value=" + value + ")", e);
        }
    }

    @Override
    public void updateFacet(DeepaMehtaObject object, String facetTypeUri, FacetValueModel value) {
        AssociationDefinition assocDef = this.getAssocDef(facetTypeUri);
        if (!this.isMultiFacet(facetTypeUri)) {
            object.updateChildTopic(value.getTopic(), assocDef);
        } else {
            object.updateChildTopics(value.getTopics(), assocDef);
        }
    }

    @Override
    public boolean hasFacet(long topicId, String facetTypeUri, long facetTopicId) {
        String assocTypeUri = this.getAssocDef(facetTypeUri).getInstanceLevelAssocTypeUri();
        Association assoc = this.dm4.getAssociation(assocTypeUri, topicId, facetTopicId, "dm4.core.parent", "dm4.core.child");
        return assoc != null;
    }

    private RelatedTopic fetchChildTopic(DeepaMehtaObject object, AssociationDefinition assocDef) {
        String assocTypeUri = assocDef.getInstanceLevelAssocTypeUri();
        String othersTypeUri = assocDef.getChildTypeUri();
        return object.getRelatedTopic(assocTypeUri, "dm4.core.parent", "dm4.core.child", othersTypeUri);
    }

    private List<RelatedTopic> fetchChildTopics(DeepaMehtaObject object, AssociationDefinition assocDef) {
        String assocTypeUri = assocDef.getInstanceLevelAssocTypeUri();
        String othersTypeUri = assocDef.getChildTypeUri();
        return object.getRelatedTopics(assocTypeUri, "dm4.core.parent", "dm4.core.child", othersTypeUri);
    }

    private boolean isMultiFacet(String facetTypeUri) {
        return this.getAssocDef(facetTypeUri).getChildCardinalityUri().equals("dm4.core.many");
    }

    private String getChildTypeUri(String facetTypeUri) {
        return this.getAssocDef(facetTypeUri).getChildTypeUri();
    }

    private AssociationDefinition getAssocDef(String facetTypeUri) {
        return (AssociationDefinition)this.dm4.getTopicType(facetTypeUri).getAssocDefs().iterator().next();
    }
}

