/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.osgi;

import de.deepamehta.core.impl.CoreServiceImpl;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.service.CoreService;
import de.deepamehta.core.service.ModelFactory;
import de.deepamehta.core.storage.spi.DeepaMehtaStorage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class CoreActivator
implements BundleActivator {
    private static BundleContext bundleContext;
    private DeepaMehtaStorage storageService;
    private static HttpService httpService;
    private ServiceTracker storageServiceTracker;
    private ServiceTracker httpServiceTracker;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext bundleContext) {
        try {
            this.logger.info("========== Starting \"DeepaMehta 4 Core\" ==========");
            CoreActivator.bundleContext = bundleContext;
            this.registerModelFactory();
            this.storageServiceTracker = this.createServiceTracker(DeepaMehtaStorage.class);
            this.storageServiceTracker.open();
            this.httpServiceTracker = this.createServiceTracker(HttpService.class);
            this.httpServiceTracker.open();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while starting \"DeepaMehta 4 Core\":", e);
        }
    }

    public void stop(BundleContext bundleContext) {
        try {
            this.logger.info("========== Stopping \"DeepaMehta 4 Core\" ==========");
            this.storageServiceTracker.close();
            this.httpServiceTracker.close();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred while stopping \"DeepaMehta 4 Core\":", e);
        }
    }

    public static CoreService getCoreService() {
        return CoreActivator.getService(CoreService.class);
    }

    public static ModelFactory getModelFactory() {
        return CoreActivator.getService(ModelFactory.class);
    }

    public static HttpService getHttpService() {
        return httpService;
    }

    public static <S> S getService(Class<S> clazz) {
        Object serviceObject = bundleContext.getService(bundleContext.getServiceReference(clazz));
        if (serviceObject == null) {
            throw new RuntimeException("Service \"" + clazz.getName() + "\" is not available");
        }
        return (S)serviceObject;
    }

    private void registerModelFactory() {
        this.logger.info("Registering ModelFactory service at OSGi framework");
        bundleContext.registerService(ModelFactory.class.getName(), (Object)new ModelFactoryImpl(), null);
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    CoreActivator.this.addService(service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "An error occurred while adding service " + serviceInterface.getName() + " to \"DeepaMehta 4 Core\":", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    CoreActivator.this.removeService(service);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    CoreActivator.this.logger.log(Level.SEVERE, "An error occurred while removing service " + serviceInterface.getName() + " from \"DeepaMehta 4 Core\":", e);
                }
            }
        };
    }

    private void addService(Object service) {
        if (service instanceof DeepaMehtaStorage) {
            this.logger.info("Adding storage service to DeepaMehta 4 Core");
            this.storageService = (DeepaMehtaStorage)service;
            this.checkRequirementsForActivation();
        } else if (service instanceof HttpService) {
            this.logger.info("Adding HTTP service to DeepaMehta 4 Core");
            httpService = (HttpService)service;
            this.checkRequirementsForActivation();
        }
    }

    private void removeService(Object service) {
        if (service == this.storageService) {
            this.logger.info("Removing storage service from DeepaMehta 4 Core");
            this.storageService = null;
        } else if (service == httpService) {
            this.logger.info("Removing HTTP service from DeepaMehta 4 Core");
            httpService = null;
        }
    }

    private void checkRequirementsForActivation() {
        if (this.storageService != null && httpService != null) {
            this.logger.info("Registering DeepaMehta 4 core service at OSGi framework");
            bundleContext.registerService(CoreService.class.getName(), (Object)new CoreServiceImpl(new PersistenceLayer(this.storageService), bundleContext), null);
        }
    }
}

