/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicReferenceModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.ModelFactory;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;

class ChildTopicsModelImpl
implements ChildTopicsModel {
    private Map<String, Object> childTopics;
    private ModelFactory mf;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsModelImpl(Map<String, Object> childTopics, ModelFactory mf) {
        this.childTopics = childTopics;
        this.mf = mf;
    }

    ChildTopicsModelImpl(ChildTopicsModelImpl childTopics) {
        this(childTopics.childTopics, childTopics.mf);
    }

    @Override
    public RelatedTopicModelImpl getTopic(String assocDefUri) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        if (topic == null) {
            throw new RuntimeException("Assoc Def URI \"" + assocDefUri + "\" not found in " + this.childTopics.keySet());
        }
        return topic;
    }

    @Override
    public RelatedTopicModelImpl getTopicOrNull(String assocDefUri) {
        try {
            return (RelatedTopicModelImpl)this.childTopics.get(assocDefUri);
        }
        catch (ClassCastException e) {
            this.throwInvalidSingleAccess(assocDefUri, e);
            return null;
        }
    }

    public List<RelatedTopicModelImpl> getTopics(String assocDefUri) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(assocDefUri);
        if (topics == null) {
            throw new RuntimeException("Assoc Def URI \"" + assocDefUri + "\" not found in " + this.childTopics.keySet());
        }
        return topics;
    }

    public List<RelatedTopicModelImpl> getTopicsOrNull(String assocDefUri) {
        try {
            return (List)this.childTopics.get(assocDefUri);
        }
        catch (ClassCastException e) {
            this.throwInvalidMultiAccess(assocDefUri, e);
            return null;
        }
    }

    @Override
    public Object get(String assocDefUri) {
        return this.childTopics.get(assocDefUri);
    }

    @Override
    public String getString(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().toString();
    }

    @Override
    public String getString(String assocDefUri, String defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().toString() : defaultValue;
    }

    @Override
    public int getInt(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().intValue();
    }

    @Override
    public int getInt(String assocDefUri, int defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().intValue() : defaultValue;
    }

    @Override
    public long getLong(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().longValue();
    }

    @Override
    public long getLong(String assocDefUri, long defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().longValue() : defaultValue;
    }

    @Override
    public double getDouble(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().doubleValue();
    }

    @Override
    public double getDouble(String assocDefUri, double defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().doubleValue() : defaultValue;
    }

    @Override
    public boolean getBoolean(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().booleanValue();
    }

    @Override
    public boolean getBoolean(String assocDefUri, boolean defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().booleanValue() : defaultValue;
    }

    @Override
    public Object getObject(String assocDefUri) {
        return this.getTopic(assocDefUri).getSimpleValue().value();
    }

    @Override
    public Object getObject(String assocDefUri, Object defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getSimpleValue().value() : defaultValue;
    }

    @Override
    public ChildTopicsModel getChildTopicsModel(String assocDefUri) {
        return this.getTopic(assocDefUri).getChildTopicsModel();
    }

    @Override
    public ChildTopicsModel getChildTopicsModel(String assocDefUri, ChildTopicsModel defaultValue) {
        RelatedTopicModelImpl topic = this.getTopicOrNull(assocDefUri);
        return topic != null ? topic.getChildTopicsModel() : defaultValue;
    }

    @Override
    public ChildTopicsModel put(String assocDefUri, RelatedTopicModel value) {
        try {
            if (value == null) {
                throw new IllegalArgumentException("Tried to put null in a ChildTopicsModel");
            }
            this.childTopics.put(assocDefUri, value);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (assocDefUri=\"" + assocDefUri + "\", value=" + value + ")", e);
        }
    }

    @Override
    public ChildTopicsModel put(String assocDefUri, TopicModel value) {
        return this.put(assocDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopicsModel put(String assocDefUri, Object value) {
        try {
            return this.put(assocDefUri, this.mf.newTopicModel(this.mf.childTypeUri(assocDefUri), new SimpleValue(value)));
        }
        catch (Exception e) {
            throw new RuntimeException("Putting a value in a ChildTopicsModel failed (assocDefUri=\"" + assocDefUri + "\", value=" + value + ")", e);
        }
    }

    @Override
    public ChildTopicsModel put(String assocDefUri, ChildTopicsModel value) {
        return this.put(assocDefUri, this.mf.newTopicModel(this.mf.childTypeUri(assocDefUri), value));
    }

    @Override
    public ChildTopicsModel putRef(String assocDefUri, long refTopicId) {
        this.put(assocDefUri, this.mf.newTopicReferenceModel(refTopicId));
        return this;
    }

    @Override
    public ChildTopicsModel putRef(String assocDefUri, String refTopicUri) {
        this.put(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri));
        return this;
    }

    @Override
    public ChildTopicsModel putDeletionRef(String assocDefUri, long refTopicId) {
        this.put(assocDefUri, this.mf.newTopicDeletionModel(refTopicId));
        return this;
    }

    @Override
    public ChildTopicsModel putDeletionRef(String assocDefUri, String refTopicUri) {
        this.put(assocDefUri, this.mf.newTopicDeletionModel(refTopicUri));
        return this;
    }

    @Override
    public ChildTopicsModel remove(String assocDefUri) {
        this.childTopics.remove(assocDefUri);
        return this;
    }

    @Override
    public ChildTopicsModel add(String assocDefUri, RelatedTopicModel value) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(assocDefUri);
        if (topics == null) {
            topics = new ArrayList<RelatedTopicModelImpl>();
            this.childTopics.put(assocDefUri, topics);
        }
        topics.add((RelatedTopicModelImpl)value);
        return this;
    }

    @Override
    public ChildTopicsModel add(String assocDefUri, TopicModel value) {
        return this.add(assocDefUri, this.mf.newRelatedTopicModel(value));
    }

    @Override
    public ChildTopicsModel put(String assocDefUri, List<RelatedTopicModel> values) {
        this.childTopics.put(assocDefUri, values);
        return this;
    }

    @Override
    public ChildTopicsModel remove(String assocDefUri, TopicModel value) {
        List<RelatedTopicModelImpl> topics = this.getTopicsOrNull(assocDefUri);
        if (topics != null) {
            topics.remove(value);
        }
        return this;
    }

    @Override
    public ChildTopicsModel addRef(String assocDefUri, long refTopicId) {
        this.add(assocDefUri, this.mf.newTopicReferenceModel(refTopicId));
        return this;
    }

    @Override
    public ChildTopicsModel addRef(String assocDefUri, String refTopicUri) {
        this.add(assocDefUri, this.mf.newTopicReferenceModel(refTopicUri));
        return this;
    }

    @Override
    public ChildTopicsModel addDeletionRef(String assocDefUri, long refTopicId) {
        this.add(assocDefUri, this.mf.newTopicDeletionModel(refTopicId));
        return this;
    }

    @Override
    public ChildTopicsModel addDeletionRef(String assocDefUri, String refTopicUri) {
        this.add(assocDefUri, this.mf.newTopicDeletionModel(refTopicUri));
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        return this.childTopics.keySet().iterator();
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject json = new JSONObject();
            for (String assocDefUri : this) {
                Object value = this.get(assocDefUri);
                if (value instanceof RelatedTopicModel) {
                    json.put(assocDefUri, (Object)((RelatedTopicModel)value).toJSON());
                    continue;
                }
                if (value instanceof List) {
                    json.put(assocDefUri, (Object)DeepaMehtaUtils.toJSONArray((List)value));
                    continue;
                }
                throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
            }
            return json;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization of a ChildTopicsModel failed (" + this + ")", e);
        }
    }

    @Override
    public ChildTopicsModel clone() {
        ChildTopicsModel clone = this.mf.newChildTopicsModel();
        for (String assocDefUri : this) {
            Object value = this.get(assocDefUri);
            if (value instanceof RelatedTopicModel) {
                RelatedTopicModel model = (RelatedTopicModel)value;
                clone.put(assocDefUri, (TopicModel)model.clone());
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopicModel model : (List)value) {
                    clone.add(assocDefUri, (TopicModel)model.clone());
                }
                continue;
            }
            throw new RuntimeException("Unexpected value in a ChildTopicsModel: " + value);
        }
        return clone;
    }

    public String toString() {
        return this.childTopics.toString();
    }

    RelatedTopicModelImpl findChildTopicById(long childTopicId, AssociationDefinitionModel assocDef) {
        List<RelatedTopicModelImpl> childTopics = this.getTopicsOrNull(assocDef.getAssocDefUri());
        if (childTopics != null) {
            for (RelatedTopicModelImpl childTopic : childTopics) {
                if (childTopic.getId() != childTopicId) continue;
                return childTopic;
            }
        }
        return null;
    }

    RelatedTopicModelImpl findChildTopicByRef(TopicReferenceModelImpl topicRef, AssociationDefinitionModel assocDef) {
        List<RelatedTopicModelImpl> childTopics = this.getTopicsOrNull(assocDef.getAssocDefUri());
        if (childTopics != null) {
            return topicRef.findReferencedTopic(childTopics);
        }
        return null;
    }

    boolean has(String assocDefUri) {
        return this.childTopics.containsKey(assocDefUri);
    }

    int size() {
        return this.childTopics.size();
    }

    void putInChildTopics(RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        this.put(assocDef.getAssocDefUri(), childTopic);
    }

    void removeChildTopic(AssociationDefinitionModel assocDef) {
        this.remove(assocDef.getAssocDefUri());
    }

    void addToChildTopics(RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        this.add(assocDef.getAssocDefUri(), childTopic);
    }

    void removeFromChildTopics(RelatedTopicModel childTopic, AssociationDefinitionModel assocDef) {
        this.remove(assocDef.getAssocDefUri(), childTopic);
    }

    private void throwInvalidSingleAccess(String assocDefUri, ClassCastException e) {
        if (e.getMessage().startsWith("java.util.ArrayList cannot be cast to")) {
            throw new RuntimeException("\"" + assocDefUri + "\" is accessed as single but is defined as multi", e);
        }
        throw new RuntimeException("Accessing \"" + assocDefUri + "\" failed", e);
    }

    private void throwInvalidMultiAccess(String assocDefUri, ClassCastException e) {
        if (e.getMessage().endsWith("cannot be cast to java.util.List")) {
            throw new RuntimeException("\"" + assocDefUri + "\" is accessed as multi but is defined as single", e);
        }
        throw new RuntimeException("Accessing \"" + assocDefUri + " failed", e);
    }
}

