/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Role;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.AssociationRoleImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedAssociationModelImpl;
import de.deepamehta.core.impl.RoleModelImpl;
import de.deepamehta.core.model.AssociationRoleModel;
import de.deepamehta.core.model.RoleModel;
import org.codehaus.jettison.json.JSONObject;

class AssociationRoleModelImpl
extends RoleModelImpl
implements AssociationRoleModel {
    AssociationRoleModelImpl(long assocId, String roleTypeUri, PersistenceLayer pl) {
        super(assocId, roleTypeUri, pl);
    }

    @Override
    public boolean refsSameObject(RoleModel model) {
        if (model instanceof AssociationRoleModel) {
            AssociationRoleModel assocRole = (AssociationRoleModel)model;
            return assocRole.getPlayerId() == this.playerId;
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        try {
            return new JSONObject().put("assoc_id", this.playerId).put("role_type_uri", (Object)this.roleTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public String toString() {
        return "\n        association role (roleTypeUri=\"" + this.roleTypeUri + "\", playerId=" + this.playerId + ")";
    }

    @Override
    Role instantiate(AssociationModelImpl assoc) {
        return new AssociationRoleImpl(this, assoc);
    }

    @Override
    RelatedAssociationModelImpl getPlayer(AssociationModelImpl assoc) {
        return this.mf.newRelatedAssociationModel(this.pl.fetchAssociation(this.playerId), assoc);
    }
}

