/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Role;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.RoleModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicRoleImpl;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicRoleModel;
import org.codehaus.jettison.json.JSONObject;

class TopicRoleModelImpl
extends RoleModelImpl
implements TopicRoleModel {
    private String topicUri;
    private boolean topicIdentifiedByUri;

    TopicRoleModelImpl(long topicId, String roleTypeUri, PersistenceLayer pl) {
        super(topicId, roleTypeUri, pl);
        this.topicUri = null;
        this.topicIdentifiedByUri = false;
    }

    TopicRoleModelImpl(String topicUri, String roleTypeUri, PersistenceLayer pl) {
        super(-1L, roleTypeUri, pl);
        this.topicUri = topicUri;
        this.topicIdentifiedByUri = true;
    }

    @Override
    public long getPlayerId() {
        if (this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by ID but by URI (" + this + ")");
        }
        return super.getPlayerId();
    }

    @Override
    public String getTopicUri() {
        if (!this.topicIdentifiedByUri) {
            throw new IllegalStateException("The topic is not identified by URI but by ID (" + this + ")");
        }
        return this.topicUri;
    }

    @Override
    public boolean topicIdentifiedByUri() {
        return this.topicIdentifiedByUri;
    }

    @Override
    public boolean refsSameObject(RoleModel model) {
        TopicRoleModel topicRole;
        if (model instanceof TopicRoleModel && (topicRole = (TopicRoleModel)model).topicIdentifiedByUri() == this.topicIdentifiedByUri) {
            if (this.topicIdentifiedByUri) {
                return topicRole.getTopicUri().equals(this.topicUri);
            }
            return topicRole.getPlayerId() == this.playerId;
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            if (this.topicIdentifiedByUri) {
                o.put("topic_uri", (Object)this.topicUri);
            } else {
                o.put("topic_id", this.playerId);
            }
            o.put("role_type_uri", (Object)this.roleTypeUri);
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    public String toString() {
        String player = this.topicIdentifiedByUri ? "topicUri=\"" + this.topicUri + "\"" : "playerId=" + this.playerId;
        return "\n        topic role (roleTypeUri=\"" + this.roleTypeUri + "\", " + player + ")";
    }

    @Override
    Role instantiate(AssociationModelImpl assoc) {
        return new TopicRoleImpl(this, assoc);
    }

    @Override
    RelatedTopicModelImpl getPlayer(AssociationModelImpl assoc) {
        TopicModelImpl topic = this.topicIdentifiedByUri ? this.pl.fetchTopic("uri", new SimpleValue(this.topicUri)) : this.pl.fetchTopic(this.playerId);
        return this.mf.newRelatedTopicModel(topic, (AssociationModel)assoc);
    }
}

