/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.ChildTopics;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.EventManager;
import de.deepamehta.core.service.Directives;
import de.deepamehta.core.service.DirectivesResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;

class JerseyResponseFilter
implements ContainerResponseFilter {
    private EventManager em;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    JerseyResponseFilter(EventManager em) {
        this.em = em;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        try {
            this.em.fireEvent(CoreEvent.SERVICE_RESPONSE_FILTER, response);
            Object entity = response.getEntity();
            boolean includeChilds = this.getIncludeChilds(request);
            boolean includeAssocChilds = this.getIncludeAssocChilds(request);
            if (entity != null) {
                if (entity instanceof DeepaMehtaObject) {
                    this.loadChildTopics((DeepaMehtaObject)entity, includeChilds, includeAssocChilds);
                } else if (this.isIterable(response, DeepaMehtaObject.class)) {
                    this.loadChildTopics((Iterable)entity, includeChilds, includeAssocChilds);
                }
                if (entity instanceof DeepaMehtaObject) {
                    this.firePreSend((DeepaMehtaObject)entity);
                } else if (this.isIterable(response, DeepaMehtaObject.class)) {
                    this.firePreSend((Iterable)entity);
                } else if (entity instanceof DirectivesResponse) {
                    this.firePreSend(((DirectivesResponse)entity).getObject());
                    this.firePreSend(((DirectivesResponse)entity).getDirectives());
                }
            }
            Directives.remove();
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Response filtering failed", e);
        }
    }

    private void loadChildTopics(DeepaMehtaObject object, boolean includeChilds, boolean includeAssocChilds) {
        if (includeChilds) {
            object.loadChildTopics();
            if (includeAssocChilds) {
                this.loadRelatingAssociationChildTopics(object);
            }
        }
    }

    private void loadChildTopics(Iterable<DeepaMehtaObject> objects, boolean includeChilds, boolean includeAssocChilds) {
        for (DeepaMehtaObject object : objects) {
            this.loadChildTopics(object, includeChilds, includeChilds);
        }
    }

    private void loadRelatingAssociationChildTopics(DeepaMehtaObject object) {
        ChildTopics childTopics = object.getChildTopics();
        for (String childTypeUri : childTopics) {
            Object value = childTopics.get(childTypeUri);
            if (value instanceof RelatedTopic) {
                RelatedTopic childTopic = (RelatedTopic)value;
                childTopic.getRelatingAssociation().loadChildTopics();
                this.loadRelatingAssociationChildTopics(childTopic);
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopic childTopic : (List)value) {
                    childTopic.getRelatingAssociation().loadChildTopics();
                    this.loadRelatingAssociationChildTopics(childTopic);
                }
                continue;
            }
            throw new RuntimeException("Unexpected \"" + childTypeUri + "\" value in ChildTopics: " + value);
        }
    }

    private void firePreSend(DeepaMehtaObject object) {
        if (object instanceof TopicType) {
            this.em.fireEvent(CoreEvent.PRE_SEND_TOPIC_TYPE, object);
        } else if (object instanceof AssociationType) {
            this.em.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION_TYPE, object);
        } else if (object instanceof Topic) {
            this.em.fireEvent(CoreEvent.PRE_SEND_TOPIC, object);
        } else if (object instanceof Association) {
            this.em.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION, object);
        }
    }

    private void firePreSend(Iterable<DeepaMehtaObject> objects) {
        for (DeepaMehtaObject object : objects) {
            this.firePreSend(object);
        }
    }

    private void firePreSend(Directives directives) {
        for (Directives.Entry entry : directives) {
            switch (entry.dir) {
                case UPDATE_TOPIC: 
                case UPDATE_ASSOCIATION: 
                case UPDATE_TOPIC_TYPE: 
                case UPDATE_ASSOCIATION_TYPE: {
                    this.firePreSend((DeepaMehtaObject)entry.arg);
                }
            }
        }
    }

    private boolean isIterable(ContainerResponse response, Class elementType) {
        Type genericType = response.getEntityType();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
            Class<?> type = response.getEntity().getClass();
            if (typeArgs.length == 1 && Iterable.class.isAssignableFrom(type) && elementType.isAssignableFrom((Class)typeArgs[0])) {
                return true;
            }
        }
        return false;
    }

    private boolean getIncludeChilds(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "include_childs");
    }

    private boolean getIncludeAssocChilds(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "include_assoc_childs");
    }

    private boolean getBooleanQueryParameter(ContainerRequest request, String param) {
        return Boolean.parseBoolean((String)request.getQueryParameters().getFirst((Object)param));
    }
}

