/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.model;

import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.TopicModel;
import java.util.ArrayList;
import java.util.List;

public enum IndexMode {
    OFF,
    KEY,
    FULLTEXT,
    FULLTEXT_KEY;

    private static final String INDEX_MODES_NAMESPACE = "dm4.core.";

    public static List<IndexMode> fromTopics(List<? extends RelatedTopicModel> topics) {
        ArrayList<IndexMode> indexModes = new ArrayList<IndexMode>();
        for (TopicModel topicModel : topics) {
            indexModes.add(IndexMode.fromUri(topicModel.getUri()));
        }
        return indexModes;
    }

    public static IndexMode fromUri(String uri) {
        if (!uri.startsWith(INDEX_MODES_NAMESPACE)) {
            throw new RuntimeException("\"" + uri + "\" is not a valid index mode URI");
        }
        String name = uri.substring(INDEX_MODES_NAMESPACE.length()).toUpperCase();
        return IndexMode.valueOf(name);
    }

    public String toUri() {
        return INDEX_MODES_NAMESPACE + this.name().toLowerCase();
    }
}

