/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationDefinitionModelImpl;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.AssociationRoleModelImpl;
import de.deepamehta.core.impl.AssociationTypeModelImpl;
import de.deepamehta.core.impl.AssociationViewModelImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.FacetValueModelImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedAssociationModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.RoleModelImpl;
import de.deepamehta.core.impl.TopicDeletionModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicReferenceModelImpl;
import de.deepamehta.core.impl.TopicRoleModelImpl;
import de.deepamehta.core.impl.TopicTypeModelImpl;
import de.deepamehta.core.impl.TopicViewModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.impl.ViewConfigurationModelImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RelatedAssociationModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicDeletionModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicReferenceModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.model.ViewConfigurationModel;
import de.deepamehta.core.model.facets.FacetValueModel;
import de.deepamehta.core.model.topicmaps.AssociationViewModel;
import de.deepamehta.core.model.topicmaps.TopicViewModel;
import de.deepamehta.core.model.topicmaps.ViewProperties;
import de.deepamehta.core.service.ModelFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ModelFactoryImpl
implements ModelFactory {
    private static final String REF_ID_PREFIX = "ref_id:";
    private static final String REF_URI_PREFIX = "ref_uri:";
    private static final String DEL_ID_PREFIX = "del_id:";
    private static final String DEL_URI_PREFIX = "del_uri:";
    PersistenceLayer pl;

    @Override
    public TopicModelImpl newTopicModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new TopicModelImpl(this.newDeepaMehtaObjectModel(id, uri, typeUri, value, childTopics));
    }

    @Override
    public TopicModelImpl newTopicModel(ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri) {
        return this.newTopicModel(-1L, null, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, null, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri) {
        return this.newTopicModel(-1L, uri, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, uri, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, uri, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(long id) {
        return this.newTopicModel(id, null, null, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(long id, ChildTopicsModel childTopics) {
        return this.newTopicModel(id, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(TopicModel topic) {
        return new TopicModelImpl((TopicModelImpl)topic);
    }

    @Override
    public TopicModelImpl newTopicModel(JSONObject topic) {
        try {
            return new TopicModelImpl(this.newDeepaMehtaObjectModel(topic));
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing TopicModel failed (JSONObject=" + topic + ")", e);
        }
    }

    @Override
    public AssociationModelImpl newAssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2, SimpleValue value, ChildTopicsModel childTopics) {
        return new AssociationModelImpl(this.newDeepaMehtaObjectModel(id, uri, typeUri, value, childTopics), (RoleModelImpl)roleModel1, (RoleModelImpl)roleModel2);
    }

    @Override
    public AssociationModelImpl newAssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.newAssociationModel(-1L, null, typeUri, roleModel1, roleModel2, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(String typeUri, RoleModel roleModel1, RoleModel roleModel2, ChildTopicsModel childTopics) {
        return this.newAssociationModel(-1L, null, typeUri, roleModel1, roleModel2, null, childTopics);
    }

    @Override
    public AssociationModelImpl newAssociationModel() {
        return this.newAssociationModel(-1L, null, null, null, null, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(ChildTopicsModel childTopics) {
        return this.newAssociationModel(-1L, null, null, null, null, null, childTopics);
    }

    @Override
    public AssociationModelImpl newAssociationModel(long id, String uri, String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.newAssociationModel(id, uri, typeUri, roleModel1, roleModel2, null, null);
    }

    @Override
    public AssociationModelImpl newAssociationModel(AssociationModel assoc) {
        return new AssociationModelImpl((AssociationModelImpl)assoc);
    }

    @Override
    public AssociationModelImpl newAssociationModel(JSONObject assoc) {
        try {
            return new AssociationModelImpl(this.newDeepaMehtaObjectModel(assoc), assoc.has("role_1") ? this.parseRole(assoc.getJSONObject("role_1")) : null, assoc.has("role_2") ? this.parseRole(assoc.getJSONObject("role_2")) : null);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationModel failed (JSONObject=" + assoc + ")", e);
        }
    }

    private RoleModelImpl parseRole(JSONObject roleModel) {
        if (roleModel.has("topic_id") || roleModel.has("topic_uri")) {
            return this.newTopicRoleModel(roleModel);
        }
        if (roleModel.has("assoc_id")) {
            return this.newAssociationRoleModel(roleModel);
        }
        throw new RuntimeException("Parsing TopicRoleModel/AssociationRoleModel failed (JSONObject=" + roleModel + ")");
    }

    DeepaMehtaObjectModelImpl newDeepaMehtaObjectModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new DeepaMehtaObjectModelImpl(id, uri, typeUri, value, (ChildTopicsModelImpl)childTopics, this.pl());
    }

    DeepaMehtaObjectModelImpl newDeepaMehtaObjectModel(JSONObject object) throws JSONException {
        return this.newDeepaMehtaObjectModel(object.optLong("id", -1L), object.optString("uri", null), object.optString("type_uri", null), object.has("value") ? new SimpleValue(object.get("value")) : null, object.has("childs") ? this.newChildTopicsModel(object.getJSONObject("childs")) : null);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel() {
        return new ChildTopicsModelImpl(new HashMap<String, Object>(), this);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel(JSONObject values) {
        try {
            HashMap<String, Object> childTopics = new HashMap<String, Object>();
            Iterator i = values.keys();
            while (i.hasNext()) {
                String assocDefUri = (String)i.next();
                String childTypeUri = this.childTypeUri(assocDefUri);
                Object value = values.get(assocDefUri);
                if (!(value instanceof JSONArray)) {
                    childTopics.put(assocDefUri, this.createTopicModel(childTypeUri, value));
                    continue;
                }
                JSONArray valueArray = (JSONArray)value;
                ArrayList<RelatedTopicModel> topics = new ArrayList<RelatedTopicModel>();
                childTopics.put(assocDefUri, topics);
                for (int j = 0; j < valueArray.length(); ++j) {
                    topics.add(this.createTopicModel(childTypeUri, valueArray.get(j)));
                }
            }
            return new ChildTopicsModelImpl(childTopics, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing ChildTopicsModel failed (JSONObject=" + values + ")", e);
        }
    }

    @Override
    public String childTypeUri(String assocDefUri) {
        return assocDefUri.split("#")[0];
    }

    private RelatedTopicModel createTopicModel(String childTypeUri, Object value) throws JSONException {
        if (value instanceof JSONObject) {
            JSONObject val = (JSONObject)value;
            if (val.has("value") || val.has("childs")) {
                RelatedTopicModel topicRef;
                AssociationModelImpl relatingAssoc = null;
                if (val.has("assoc")) {
                    relatingAssoc = this.newAssociationModel(val.getJSONObject("assoc"));
                }
                if (val.has("value") && (topicRef = this.createReferenceModel(val.get("value"), relatingAssoc)) != null) {
                    return topicRef;
                }
                this.initTypeUri(val, childTypeUri);
                TopicModelImpl topic = this.newTopicModel(val);
                if (relatingAssoc != null) {
                    return this.newRelatedTopicModel(topic, (AssociationModel)relatingAssoc);
                }
                return this.newRelatedTopicModel(topic);
            }
            return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, (ChildTopicsModel)this.newChildTopicsModel(val)));
        }
        RelatedTopicModel topicRef = this.createReferenceModel(value, null);
        if (topicRef != null) {
            return topicRef;
        }
        return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, new SimpleValue(value)));
    }

    private RelatedTopicModel createReferenceModel(Object value, AssociationModel relatingAssoc) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.startsWith(REF_ID_PREFIX)) {
                long topicId = this.refTopicId(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicId, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicId);
            }
            if (val.startsWith(REF_URI_PREFIX)) {
                String topicUri = this.refTopicUri(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicUri, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicUri);
            }
            if (val.startsWith(DEL_ID_PREFIX)) {
                return this.newTopicDeletionModel(this.delTopicId(val));
            }
            if (val.startsWith(DEL_URI_PREFIX)) {
                return this.newTopicDeletionModel(this.delTopicUri(val));
            }
        }
        return null;
    }

    private void initTypeUri(JSONObject value, String childTypeUri) throws JSONException {
        if (!value.has("type_uri")) {
            value.put("type_uri", (Object)childTypeUri);
        } else {
            String typeUri = value.getString("type_uri");
            if (!typeUri.equals(childTypeUri)) {
                throw new IllegalArgumentException("A \"" + childTypeUri + "\" topic model has type_uri=\"" + typeUri + "\"");
            }
        }
    }

    private long refTopicId(String val) {
        return Long.parseLong(val.substring(REF_ID_PREFIX.length()));
    }

    private String refTopicUri(String val) {
        return val.substring(REF_URI_PREFIX.length());
    }

    private long delTopicId(String val) {
        return Long.parseLong(val.substring(DEL_ID_PREFIX.length()));
    }

    private String delTopicUri(String val) {
        return val.substring(DEL_URI_PREFIX.length());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(long topicId, String roleTypeUri) {
        return new TopicRoleModelImpl(topicId, roleTypeUri, this.pl());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(String topicUri, String roleTypeUri) {
        return new TopicRoleModelImpl(topicUri, roleTypeUri, this.pl());
    }

    @Override
    public TopicRoleModelImpl newTopicRoleModel(JSONObject topicRoleModel) {
        try {
            long topicId = topicRoleModel.optLong("topic_id", -1L);
            String topicUri = topicRoleModel.optString("topic_uri", null);
            String roleTypeUri = topicRoleModel.getString("role_type_uri");
            if (topicId == -1L && topicUri == null) {
                throw new IllegalArgumentException("Neiter \"topic_id\" nor \"topic_uri\" is set");
            }
            if (topicId != -1L && topicUri != null) {
                throw new IllegalArgumentException("\"topic_id\" and \"topic_uri\" must not be set at the same time");
            }
            if (topicId != -1L) {
                return this.newTopicRoleModel(topicId, roleTypeUri);
            }
            return this.newTopicRoleModel(topicUri, roleTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing TopicRoleModel failed (JSONObject=" + topicRoleModel + ")", e);
        }
    }

    @Override
    public AssociationRoleModelImpl newAssociationRoleModel(long assocId, String roleTypeUri) {
        return new AssociationRoleModelImpl(assocId, roleTypeUri, this.pl());
    }

    @Override
    public AssociationRoleModelImpl newAssociationRoleModel(JSONObject assocRoleModel) {
        try {
            long assocId = assocRoleModel.getLong("assoc_id");
            String roleTypeUri = assocRoleModel.getString("role_type_uri");
            return this.newAssociationRoleModel(assocId, roleTypeUri);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationRoleModel failed (JSONObject=" + assocRoleModel + ")", e);
        }
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, SimpleValue value) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, value), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, ChildTopicsModel childTopics) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, childTopics), this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, this.newAssociationModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic, AssociationModel relatingAssoc) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public RelatedAssociationModel newRelatedAssociationModel(AssociationModel assoc, AssociationModel relatingAssoc) {
        return new RelatedAssociationModelImpl((AssociationModelImpl)assoc, (AssociationModelImpl)relatingAssoc);
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, AssociationModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, AssociationModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, (AssociationModel)this.newAssociationModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, (AssociationModel)this.newAssociationModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(long topicId) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(String topicUri) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(TopicModel typeTopic, String dataTypeUri, List<IndexMode> indexModes, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModel viewConfig) {
        return new TopicTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, indexModes, assocDefs, (ViewConfigurationModelImpl)viewConfig));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(String uri, String value, String dataTypeUri) {
        return new TopicTypeModelImpl(this.newTypeModel(uri, "dm4.core.topic_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(JSONObject topicType) {
        try {
            return new TopicTypeModelImpl(this.newTypeModel(topicType.put("type_uri", (Object)"dm4.core.topic_type")));
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing TopicTypeModel failed (JSONObject=" + topicType + ")", e);
        }
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(TopicModel typeTopic, String dataTypeUri, List<IndexMode> indexModes, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModel viewConfig) {
        return new AssociationTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, indexModes, assocDefs, (ViewConfigurationModelImpl)viewConfig));
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(String uri, String value, String dataTypeUri) {
        return new AssociationTypeModelImpl(this.newTypeModel(uri, "dm4.core.assoc_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public AssociationTypeModelImpl newAssociationTypeModel(JSONObject assocType) {
        try {
            return new AssociationTypeModelImpl(this.newTypeModel(assocType.put("type_uri", (Object)"dm4.core.assoc_type")));
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationTypeModel failed (JSONObject=" + assocType + ")", e);
        }
    }

    TypeModelImpl newTypeModel(TopicModel typeTopic, String dataTypeUri, List<IndexMode> indexModes, List<AssociationDefinitionModel> assocDefs, ViewConfigurationModelImpl viewConfig) {
        return new TypeModelImpl((TopicModelImpl)typeTopic, dataTypeUri, indexModes, assocDefs, viewConfig);
    }

    TypeModelImpl newTypeModel(String uri, String typeUri, SimpleValue value, String dataTypeUri) {
        return new TypeModelImpl(this.newTopicModel(uri, typeUri, value), dataTypeUri, new ArrayList<IndexMode>(), new ArrayList<AssociationDefinitionModel>(), this.newViewConfigurationModel());
    }

    TypeModelImpl newTypeModel(JSONObject typeModel) throws JSONException {
        TopicModelImpl typeTopic = this.newTopicModel(typeModel);
        return new TypeModelImpl(typeTopic, typeModel.optString("data_type_uri", null), this.parseIndexModes(typeModel.optJSONArray("index_mode_uris")), this.parseAssocDefs(typeModel.optJSONArray("assoc_defs"), typeTopic.getUri()), this.newViewConfigurationModel(typeModel.optJSONArray("view_config_topics")));
    }

    private List<IndexMode> parseIndexModes(JSONArray indexModeUris) {
        try {
            ArrayList<IndexMode> indexModes = new ArrayList<IndexMode>();
            if (indexModeUris != null) {
                for (int i = 0; i < indexModeUris.length(); ++i) {
                    indexModes.add(IndexMode.fromUri(indexModeUris.getString(i)));
                }
            }
            return indexModes;
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing index modes failed (JSONArray=" + indexModeUris + ")", e);
        }
    }

    private List<AssociationDefinitionModel> parseAssocDefs(JSONArray assocDefs, String parentTypeUri) throws JSONException {
        ArrayList<AssociationDefinitionModel> _assocDefs = new ArrayList<AssociationDefinitionModel>();
        if (assocDefs != null) {
            for (int i = 0; i < assocDefs.length(); ++i) {
                JSONObject assocDef = assocDefs.getJSONObject(i).put("parent_type_uri", (Object)parentTypeUri);
                _assocDefs.add(this.newAssociationDefinitionModel(assocDef));
            }
        }
        return _assocDefs;
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(String assocTypeUri, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri) {
        return this.newAssociationDefinitionModel(-1L, null, assocTypeUri, null, false, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri, null);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(String assocTypeUri, String customAssocTypeUri, boolean includeInLabel, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri) {
        return this.newAssociationDefinitionModel(-1L, null, assocTypeUri, customAssocTypeUri, includeInLabel, parentTypeUri, childTypeUri, parentCardinalityUri, childCardinalityUri, null);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(AssociationModel assoc, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModel viewConfig) {
        return new AssociationDefinitionModelImpl((AssociationModelImpl)assoc, parentCardinalityUri, childCardinalityUri, (ViewConfigurationModelImpl)viewConfig);
    }

    @Override
    public AssociationDefinitionModelImpl newAssociationDefinitionModel(JSONObject assocDef) {
        try {
            AssociationModelImpl assoc = this.newAssociationModel(assocDef.optLong("id", -1L), null, assocDef.getString("assoc_type_uri"), this.parentRole(assocDef.getString("parent_type_uri")), this.childRole(assocDef.getString("child_type_uri")), null, this.childTopics(assocDef));
            if (!assocDef.has("parent_cardinality_uri") && !assoc.getTypeUri().equals("dm4.core.composition_def")) {
                throw new RuntimeException("\"parent_cardinality_uri\" is missing");
            }
            return new AssociationDefinitionModelImpl(assoc, assocDef.optString("parent_cardinality_uri", "dm4.core.one"), assocDef.getString("child_cardinality_uri"), this.newViewConfigurationModel(assocDef.optJSONArray("view_config_topics")));
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing AssociationDefinitionModel failed (JSONObject=" + assocDef + ")", e);
        }
    }

    AssociationDefinitionModelImpl newAssociationDefinitionModel(long id, String uri, String assocTypeUri, String customAssocTypeUri, boolean includeInLabel, String parentTypeUri, String childTypeUri, String parentCardinalityUri, String childCardinalityUri, ViewConfigurationModel viewConfig) {
        return new AssociationDefinitionModelImpl(this.newAssociationModel(id, uri, assocTypeUri, this.parentRole(parentTypeUri), this.childRole(childTypeUri), null, this.childTopics(customAssocTypeUri, includeInLabel)), parentCardinalityUri, childCardinalityUri, (ViewConfigurationModelImpl)viewConfig);
    }

    AssociationDefinitionModelImpl newAssociationDefinitionModel(ChildTopicsModel childTopics) {
        return new AssociationDefinitionModelImpl(this.newAssociationModel(childTopics));
    }

    private TopicRoleModel parentRole(String parentTypeUri) {
        return this.newTopicRoleModel(parentTypeUri, "dm4.core.parent_type");
    }

    private TopicRoleModel childRole(String childTypeUri) {
        return this.newTopicRoleModel(childTypeUri, "dm4.core.child_type");
    }

    private ChildTopicsModel childTopics(JSONObject assocDef) throws JSONException {
        String customAssocTypeUri = assocDef.isNull("custom_assoc_type_uri") ? null : assocDef.getString("custom_assoc_type_uri");
        boolean includeInLabel = assocDef.optBoolean("include_in_label");
        return this.childTopics(customAssocTypeUri, includeInLabel);
    }

    private ChildTopicsModel childTopics(String customAssocTypeUri, boolean includeInLabel) {
        ChildTopicsModelImpl childTopics = this.newChildTopicsModel();
        childTopics.put("dm4.core.include_in_label", includeInLabel);
        if (customAssocTypeUri != null) {
            if (customAssocTypeUri.startsWith(DEL_URI_PREFIX)) {
                childTopics.putDeletionRef("dm4.core.assoc_type#dm4.core.custom_assoc_type", this.delTopicUri(customAssocTypeUri));
            } else {
                childTopics.putRef("dm4.core.assoc_type#dm4.core.custom_assoc_type", customAssocTypeUri);
            }
        }
        return childTopics;
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel() {
        return new ViewConfigurationModelImpl(new HashMap<String, TopicModelImpl>());
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel(Iterable<? extends TopicModel> configTopics) {
        HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
        for (TopicModel topicModel : configTopics) {
            _configTopics.put(topicModel.getTypeUri(), (TopicModelImpl)topicModel);
        }
        return new ViewConfigurationModelImpl(_configTopics);
    }

    @Override
    public ViewConfigurationModelImpl newViewConfigurationModel(JSONArray configTopics) {
        try {
            HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
            if (configTopics != null) {
                for (int i = 0; i < configTopics.length(); ++i) {
                    TopicModelImpl configTopic = this.newTopicModel(configTopics.getJSONObject(i));
                    _configTopics.put(configTopic.getTypeUri(), configTopic);
                }
            }
            return new ViewConfigurationModelImpl(_configTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing ViewConfigurationModel failed (JSONArray=" + configTopics + ")", e);
        }
    }

    @Override
    public TopicViewModel newTopicViewModel(TopicModel topic, ViewProperties viewProps) {
        return new TopicViewModelImpl((TopicModelImpl)topic, viewProps);
    }

    @Override
    public AssociationViewModel newAssociationViewModel(AssociationModel assoc) {
        return new AssociationViewModelImpl((AssociationModelImpl)assoc);
    }

    @Override
    public FacetValueModel newFacetValueModel(String childTypeUri) {
        return new FacetValueModelImpl(childTypeUri, (ModelFactory)this);
    }

    @Override
    public FacetValueModel newFacetValueModel(JSONObject facetValue) {
        try {
            ChildTopicsModelImpl childTopics = this.newChildTopicsModel(facetValue);
            if (childTopics.size() != 1) {
                throw new RuntimeException("There are " + childTopics.size() + " child topic entries (expected is 1)");
            }
            return new FacetValueModelImpl(childTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing FacetValueModel failed (JSONObject=" + facetValue + ")", e);
        }
    }

    private PersistenceLayer pl() {
        if (this.pl == null) {
            throw new RuntimeException("before using the ModelFactory a PersistenceLayer must be set");
        }
        return this.pl;
    }
}

