/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedAssociation;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Role;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicRole;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.DeepaMehtaObjectImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedAssociationModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicRoleModel;
import java.util.List;
import java.util.logging.Logger;

class AssociationImpl
extends DeepaMehtaObjectImpl
implements Association {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    AssociationImpl(AssociationModelImpl model, PersistenceLayer pl) {
        super(model, pl);
    }

    @Override
    public Role getRole1() {
        return this.getModel().getRoleModel1().instantiate(this.getModel());
    }

    @Override
    public Role getRole2() {
        return this.getModel().getRoleModel2().instantiate(this.getModel());
    }

    @Override
    public DeepaMehtaObject getPlayer1() {
        return this.getRole1().getPlayer();
    }

    @Override
    public DeepaMehtaObject getPlayer2() {
        return this.getRole2().getPlayer();
    }

    @Override
    public Role getRole(String roleTypeUri) {
        return this.getModel().getRoleModel(roleTypeUri).instantiate(this.getModel());
    }

    @Override
    public boolean hasSameRoleTypeUris() {
        return this.getModel().hasSameRoleTypeUris();
    }

    @Override
    public boolean matches(String roleTypeUri1, long playerId1, String roleTypeUri2, long playerId2) {
        return this.getModel().matches(roleTypeUri1, playerId1, roleTypeUri2, playerId2);
    }

    @Override
    public long getOtherPlayerId(long id) {
        return this.getModel().getOtherPlayerId(id);
    }

    @Override
    public Topic getTopic(String roleTypeUri) {
        TopicModelImpl topic = this.getModel().getTopic(roleTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public Topic getTopicByType(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().getTopicByType(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public Role getRole(RoleModel roleModel) {
        if (this.getRole1().getModel().refsSameObject(roleModel)) {
            return this.getRole1();
        }
        if (this.getRole2().getModel().refsSameObject(roleModel)) {
            return this.getRole2();
        }
        throw new RuntimeException("Role is not part of association (role=" + roleModel + ", association=" + this);
    }

    @Override
    public boolean isPlayer(TopicRoleModel roleModel) {
        return this.filterRole(this.getRole1(), roleModel) != null || this.filterRole(this.getRole2(), roleModel) != null;
    }

    @Override
    public void update(AssociationModel updateModel) {
        this.model.update((AssociationModelImpl)updateModel);
    }

    @Override
    public Association loadChildTopics() {
        this.model.loadChildTopics();
        return this;
    }

    @Override
    public Association loadChildTopics(String assocDefUri) {
        this.model.loadChildTopics(assocDefUri);
        return this;
    }

    @Override
    public AssociationModelImpl getModel() {
        return (AssociationModelImpl)this.model;
    }

    @Override
    public List<RelatedTopic> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.pl.fetchAssociationRelatedTopics(this.getId(), assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return this.pl.checkReadAccessAndInstantiate(topics);
    }

    @Override
    public RelatedAssociation getRelatedAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssociationModelImpl assoc = this.pl.fetchAssociationRelatedAssociation(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? (RelatedAssociation)this.pl.checkReadAccessAndInstantiate(assoc) : null;
    }

    @Override
    public List<RelatedAssociation> getRelatedAssociations(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        List<RelatedAssociationModelImpl> assocs = this.pl.fetchAssociationRelatedAssociations(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return this.pl.checkReadAccessAndInstantiate(assocs);
    }

    @Override
    public Association getAssociation(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        AssociationModelImpl assoc = this.pl.fetchAssociationBetweenTopicAndAssociation(assocTypeUri, othersTopicId, this.getId(), othersRoleTypeUri, myRoleTypeUri);
        return assoc != null ? (Association)this.pl.checkReadAccessAndInstantiate(assoc) : null;
    }

    @Override
    public List<Association> getAssociations() {
        return this.pl.checkReadAccessAndInstantiate(this.pl.fetchAssociationAssociations(this.getId()));
    }

    private TopicRole filterRole(Role role, TopicRoleModel roleModel) {
        return role instanceof TopicRole && role.getRoleTypeUri().equals(roleModel.getRoleTypeUri()) && role.getPlayerId() == roleModel.getPlayerId() ? (TopicRole)role : null;
    }
}

