/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.TopicImpl;
import de.deepamehta.core.model.AssociationDefinitionModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.model.TopicTypeModel;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.Directive;
import java.util.List;

class TopicModelImpl
extends DeepaMehtaObjectModelImpl
implements TopicModel {
    TopicModelImpl(DeepaMehtaObjectModelImpl object) {
        super(object);
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        return this.mf.newTopicRoleModel(this.id, roleTypeUri);
    }

    @Override
    public TopicModel clone() {
        try {
            return (TopicModel)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a TopicModel failed", e);
        }
    }

    @Override
    public String toString() {
        return "topic (" + super.toString() + ")";
    }

    @Override
    String className() {
        return "topic";
    }

    @Override
    TopicImpl instantiate() {
        return new TopicImpl(this, this.pl);
    }

    @Override
    TopicTypeModel getType() {
        return this.pl.typeStorage.getTopicType(this.typeUri);
    }

    @Override
    List<AssociationModelImpl> getAssociations() {
        return this.pl.fetchTopicAssociations(this.id);
    }

    @Override
    RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchTopicRelatedTopics(this.id, assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    void storeUri() {
        this.pl.storeTopicUri(this.id, this.uri);
    }

    @Override
    void storeTypeUri() {
        this.reassignInstantiation();
        this.pl.storeTopicTypeUri(this.id, this.typeUri);
    }

    @Override
    void storeSimpleValue() {
        TopicTypeModel type = this.getType();
        this.pl.storeTopicValue(this.id, this.value, type.getIndexModes(), type.getUri(), this.getIndexValue());
    }

    @Override
    void indexSimpleValue(IndexMode indexMode) {
        this.pl.indexTopicValue(this.id, indexMode, this.typeUri, this.getIndexValue());
    }

    @Override
    void updateChildTopics(ChildTopicsModel childTopics) {
        this.update(this.mf.newTopicModel(childTopics));
    }

    @Override
    void _delete() {
        this.pl._deleteTopic(this.id);
    }

    @Override
    DeepaMehtaEvent getReadAccessEvent() {
        return CoreEvent.CHECK_TOPIC_READ_ACCESS;
    }

    @Override
    DeepaMehtaEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_TOPIC;
    }

    @Override
    DeepaMehtaEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_TOPIC;
    }

    @Override
    DeepaMehtaEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_TOPIC;
    }

    @Override
    DeepaMehtaEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_TOPIC;
    }

    @Override
    Directive getUpdateDirective() {
        return Directive.UPDATE_TOPIC;
    }

    @Override
    Directive getDeleteDirective() {
        return Directive.DELETE_TOPIC;
    }

    @Override
    void preDelete() {
        if (this.typeUri.equals("dm4.core.topic_type") || this.typeUri.equals("dm4.core.assoc_type")) {
            throw new RuntimeException("Tried to delete a type with a generic delete-topic call. Use a delete-type call instead.");
        }
    }

    TopicModelImpl findChildTopic(String topicTypeUri) {
        if (this.typeUri.equals(topicTypeUri)) {
            return this;
        }
        for (AssociationDefinitionModel associationDefinitionModel : this.getType().getAssocDefs()) {
            String assocDefUri = associationDefinitionModel.getAssocDefUri();
            String cardinalityUri = associationDefinitionModel.getChildCardinalityUri();
            TopicModelImpl childTopic = null;
            if (cardinalityUri.equals("dm4.core.one")) {
                childTopic = this.childTopics.getTopicOrNull(assocDefUri);
            } else if (cardinalityUri.equals("dm4.core.many")) {
                List<RelatedTopicModelImpl> _childTopics = this.childTopics.getTopicsOrNull(assocDefUri);
                if (_childTopics != null && !_childTopics.isEmpty()) {
                    childTopic = _childTopics.get(0);
                }
            } else {
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            if (childTopic == null || (childTopic = childTopic.findChildTopic(topicTypeUri)) == null) continue;
            return childTopic;
        }
        return null;
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.pl.createTopicInstantiation(this.id, this.typeUri);
    }

    private AssociationModelImpl fetchInstantiation() {
        RelatedTopicModelImpl topicType = this.getRelatedTopic("dm4.core.instantiation", "dm4.core.instance", "dm4.core.type", "dm4.core.topic_type");
        if (topicType == null) {
            throw new RuntimeException("Topic " + this.id + " is not associated to a topic type");
        }
        return topicType.getRelatingAssociation();
    }
}

