/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.impl.AssociationImpl;
import de.deepamehta.core.impl.AssociationIterable;
import de.deepamehta.core.impl.AssociationModelImpl;
import de.deepamehta.core.impl.AssociationTypeImpl;
import de.deepamehta.core.impl.AssociationTypeModelImpl;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.EventManager;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.StorageDecorator;
import de.deepamehta.core.impl.TopicImpl;
import de.deepamehta.core.impl.TopicIterable;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicTypeImpl;
import de.deepamehta.core.impl.TopicTypeModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.impl.TypeStorage;
import de.deepamehta.core.impl.ValueStorage;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.service.accesscontrol.AccessControlException;
import de.deepamehta.core.storage.spi.DeepaMehtaStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class PersistenceLayer
extends StorageDecorator {
    private static final String URI_PREFIX_TOPIC_TYPE = "domain.project.topic_type_";
    private static final String URI_PREFIX_ASSOCIATION_TYPE = "domain.project.assoc_type_";
    private static final String URI_PREFIX_ROLE_TYPE = "domain.project.role_type_";
    TypeStorage typeStorage;
    ValueStorage valueStorage;
    EventManager em;
    ModelFactoryImpl mf;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public PersistenceLayer(DeepaMehtaStorage storage) {
        super(storage);
        this.em = new EventManager();
        this.mf = (ModelFactoryImpl)storage.getModelFactory();
        this.typeStorage = new TypeStorage(this);
        this.valueStorage = new ValueStorage(this);
        this.mf.pl = this;
        this.bootstrapTypeCache();
    }

    Topic getTopic(long topicId) {
        try {
            return (Topic)this.checkReadAccessAndInstantiate(this.fetchTopic(topicId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic " + topicId + " failed", e);
        }
    }

    TopicImpl getTopicByUri(String uri) {
        return this.getTopicByValue("uri", new SimpleValue(uri));
    }

    TopicImpl getTopicByValue(String key, SimpleValue value) {
        try {
            TopicModelImpl topic = this.fetchTopic(key, value);
            return topic != null ? (TopicImpl)this.checkReadAccessAndInstantiate(topic) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topic failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Topic> getTopicsByValue(String key, SimpleValue value) {
        try {
            return this.checkReadAccessAndInstantiate(this.fetchTopics(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Topic> getTopicsByType(String topicTypeUri) {
        try {
            return this.checkReadAccessAndInstantiate(this._getTopicType(topicTypeUri).getAllInstances());
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching topics by type failed (topicTypeUri=\"" + topicTypeUri + "\")", e);
        }
    }

    List<Topic> searchTopics(String searchTerm, String fieldUri) {
        try {
            return this.checkReadAccessAndInstantiate(this.queryTopics(fieldUri, new SimpleValue(searchTerm)));
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topics failed (searchTerm=\"" + searchTerm + "\", fieldUri=\"" + fieldUri + "\")", e);
        }
    }

    Iterable<Topic> getAllTopics() {
        return new TopicIterable(this);
    }

    TopicImpl createTopic(TopicModelImpl model) {
        return this.createTopic(model, null);
    }

    TopicImpl createTopic(TopicModelImpl model, String uriPrefix) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_TOPIC, model);
            model.preCreate();
            this.storeTopic(model);
            this.valueStorage.storeValue(model);
            this.createTopicInstantiation(model.getId(), model.getTypeUri());
            if (uriPrefix != null && model.getUri().equals("")) {
                model.updateUri(uriPrefix + model.getId());
            }
            TopicImpl topic = model.instantiate();
            model.postCreate();
            this.em.fireEvent(CoreEvent.POST_CREATE_TOPIC, topic);
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic " + model.getId() + " failed (typeUri=\"" + model.getTypeUri() + "\")", e);
        }
    }

    void updateTopic(TopicModelImpl newModel) {
        long topicId = newModel.getId();
        try {
            this.checkTopicWriteAccess(topicId);
            TopicModelImpl model = this.fetchTopic(topicId);
            model.update(newModel);
            this.em.fireEvent(CoreEvent.POST_UPDATE_TOPIC_REQUEST, model.instantiate());
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic " + topicId + " failed", e);
        }
    }

    void deleteTopic(long topicId) {
        try {
            this.checkTopicWriteAccess(topicId);
            this.fetchTopic(topicId).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic " + topicId + " failed", e);
        }
    }

    Association getAssociation(long assocId) {
        try {
            return (Association)this.checkReadAccessAndInstantiate(this.fetchAssociation(assocId));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association " + assocId + " failed", e);
        }
    }

    Association getAssociationByValue(String key, SimpleValue value) {
        try {
            AssociationModelImpl assoc = this.fetchAssociation(key, value);
            return assoc != null ? (Association)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    List<Association> getAssociationsByValue(String key, SimpleValue value) {
        try {
            return this.checkReadAccessAndInstantiate(this.fetchAssociations(key, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associationss failed (key=\"" + key + "\", value=\"" + value + "\")", e);
        }
    }

    Association getAssociation(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\"";
        try {
            AssociationModelImpl assoc = this.fetchAssociation(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
            return assoc != null ? (Association)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    Association getAssociationBetweenTopicAndAssociation(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        String info = "assocTypeUri=\"" + assocTypeUri + "\", topicId=" + topicId + ", assocId=" + assocId + ", topicRoleTypeUri=\"" + topicRoleTypeUri + "\", assocRoleTypeUri=\"" + assocRoleTypeUri + "\"";
        this.logger.info(info);
        try {
            AssociationModelImpl assoc = this.fetchAssociationBetweenTopicAndAssociation(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
            return assoc != null ? (Association)this.checkReadAccessAndInstantiate(assoc) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching association failed (" + info + ")", e);
        }
    }

    List<Association> getAssociationsByType(String assocTypeUri) {
        try {
            return this.checkReadAccessAndInstantiate(this._getAssociationType(assocTypeUri).getAllInstances());
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations by type failed (assocTypeUri=\"" + assocTypeUri + "\")", e);
        }
    }

    List<Association> getAssociations(long topic1Id, long topic2Id) {
        return this.getAssociations(null, topic1Id, topic2Id);
    }

    List<Association> getAssociations(String assocTypeUri, long topic1Id, long topic2Id) {
        return this.getAssociations(assocTypeUri, topic1Id, topic2Id, null, null);
    }

    List<Association> getAssociations(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        return this.instantiate(this._getAssociations(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2));
    }

    Iterable<AssociationModelImpl> _getAssociations(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        this.logger.fine("assocTypeUri=\"" + assocTypeUri + "\", topic1Id=" + topic1Id + ", topic2Id=" + topic2Id + ", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\"");
        try {
            return this.filterReadables(this.fetchAssociations(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching associations between topics " + topic1Id + " and " + topic2Id + " failed (assocTypeUri=\"" + assocTypeUri + "\", roleTypeUri1=\"" + roleTypeUri1 + "\", roleTypeUri2=\"" + roleTypeUri2 + "\")", e);
        }
    }

    Iterable<Association> getAllAssociations() {
        return new AssociationIterable(this);
    }

    long[] getPlayerIds(long assocId) {
        return this.fetchPlayerIds(assocId);
    }

    AssociationImpl createAssociation(String typeUri, RoleModel roleModel1, RoleModel roleModel2) {
        return this.createAssociation(this.mf.newAssociationModel(typeUri, roleModel1, roleModel2));
    }

    AssociationImpl createAssociation(AssociationModelImpl model) {
        try {
            this.em.fireEvent(CoreEvent.PRE_CREATE_ASSOCIATION, model);
            model.preCreate();
            this.storeAssociation(model);
            this.valueStorage.storeValue(model);
            this.createAssociationInstantiation(model.getId(), model.getTypeUri());
            AssociationImpl assoc = model.instantiate();
            model.postCreate();
            this.em.fireEvent(CoreEvent.POST_CREATE_ASSOCIATION, assoc);
            return assoc;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association failed (" + model + ")", e);
        }
    }

    void updateAssociation(AssociationModelImpl newModel) {
        long assocId = newModel.getId();
        try {
            this.checkAssociationWriteAccess(assocId);
            AssociationModelImpl model = this.fetchAssociation(assocId);
            model.update(newModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association " + assocId + " failed", e);
        }
    }

    void deleteAssociation(long assocId) {
        try {
            this.checkAssociationWriteAccess(assocId);
            this.fetchAssociation(assocId).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association " + assocId + " failed", e);
        }
    }

    void createTopicInstantiation(long topicId, String topicTypeUri) {
        try {
            AssociationModelImpl assoc = this.mf.newAssociationModel("dm4.core.instantiation", this.mf.newTopicRoleModel(topicTypeUri, "dm4.core.type"), this.mf.newTopicRoleModel(topicId, "dm4.core.instance"));
            this.storeAssociation(assoc);
            this.storeAssociationValue(assoc.getId(), assoc.getSimpleValue());
            this.createAssociationInstantiation(assoc.getId(), assoc.getTypeUri());
        }
        catch (Exception e) {
            throw new RuntimeException("Associating topic " + topicId + " with topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    void createAssociationInstantiation(long assocId, String assocTypeUri) {
        try {
            AssociationModelImpl assoc = this.mf.newAssociationModel("dm4.core.instantiation", this.mf.newTopicRoleModel(assocTypeUri, "dm4.core.type"), this.mf.newAssociationRoleModel(assocId, "dm4.core.instance"));
            this.storeAssociation(assoc);
            this.storeAssociationValue(assoc.getId(), assoc.getSimpleValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Associating association " + assocId + " with association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    TopicType getTopicType(String uri) {
        TopicTypeModelImpl topicType = this._getTopicType(uri);
        if (!uri.equals("dm4.core.meta_meta_type")) {
            this.checkReadAccess(topicType);
        }
        return topicType.instantiate();
    }

    TopicType getTopicTypeImplicitly(long topicId) {
        this.checkTopicReadAccess(topicId);
        return this._getTopicType(this.typeUri(topicId)).instantiate();
    }

    AssociationType getAssociationType(String uri) {
        return (AssociationType)this.checkReadAccessAndInstantiate(this._getAssociationType(uri));
    }

    AssociationType getAssociationTypeImplicitly(long assocId) {
        this.checkAssociationReadAccess(assocId);
        return this._getAssociationType(this.typeUri(assocId)).instantiate();
    }

    List<TopicType> getAllTopicTypes() {
        try {
            ArrayList<TopicType> topicTypes = new ArrayList<TopicType>();
            for (String uri : this.getTopicTypeUris()) {
                topicTypes.add(this._getTopicType(uri).instantiate());
            }
            return topicTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all topic types failed", e);
        }
    }

    List<AssociationType> getAllAssociationTypes() {
        try {
            ArrayList<AssociationType> assocTypes = new ArrayList<AssociationType>();
            for (String uri : this.getAssociationTypeUris()) {
                assocTypes.add(this._getAssociationType(uri).instantiate());
            }
            return assocTypes;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching all association types failed", e);
        }
    }

    TopicType createTopicType(TopicTypeModelImpl model) {
        try {
            this.createTypeTopic(model, URI_PREFIX_TOPIC_TYPE);
            TopicTypeImpl topicType = model.instantiate();
            this.em.fireEvent(CoreEvent.INTRODUCE_TOPIC_TYPE, topicType);
            return topicType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating topic type \"" + model.getUri() + "\" failed", e);
        }
    }

    AssociationType createAssociationType(AssociationTypeModelImpl model) {
        try {
            this.createTypeTopic(model, URI_PREFIX_ASSOCIATION_TYPE);
            AssociationTypeImpl assocType = model.instantiate();
            this.em.fireEvent(CoreEvent.INTRODUCE_ASSOCIATION_TYPE, assocType);
            return assocType;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating association type \"" + model.getUri() + "\" failed", e);
        }
    }

    void updateTopicType(TopicTypeModelImpl newModel) {
        try {
            String topicTypeUri = this.fetchTopic(newModel.getId()).getUri();
            this._getTopicType(topicTypeUri).update(newModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating topic type failed (" + newModel + ")", e);
        }
    }

    void updateAssociationType(AssociationTypeModelImpl newModel) {
        try {
            String assocTypeUri = this.fetchTopic(newModel.getId()).getUri();
            this._getAssociationType(assocTypeUri).update(newModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Updating association type failed (" + newModel + ")", e);
        }
    }

    void deleteTopicType(String topicTypeUri) {
        try {
            this._getTopicType(topicTypeUri).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting topic type \"" + topicTypeUri + "\" failed", e);
        }
    }

    void deleteAssociationType(String assocTypeUri) {
        try {
            this._getAssociationType(assocTypeUri).delete();
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting association type \"" + assocTypeUri + "\" failed", e);
        }
    }

    Topic createRoleType(TopicModelImpl model) {
        String typeUri = model.getTypeUri();
        if (typeUri == null) {
            model.setTypeUri("dm4.core.role_type");
        } else if (!typeUri.equals("dm4.core.role_type")) {
            throw new IllegalArgumentException("A role type is supposed to be of type \"dm4.core.role_type\" (found: \"" + typeUri + "\")");
        }
        return this.createTopic(model, URI_PREFIX_ROLE_TYPE);
    }

    TopicTypeModelImpl _getTopicType(String uri) {
        return this.typeStorage.getTopicType(uri);
    }

    AssociationTypeModelImpl _getAssociationType(String uri) {
        return this.typeStorage.getAssociationType(uri);
    }

    DeepaMehtaObject getObject(long id) {
        return (DeepaMehtaObject)this.checkReadAccessAndInstantiate(this.fetchObject(id));
    }

    List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.checkReadAccessAndInstantiate(this.fetchTopicsByProperty(propUri, propValue));
    }

    List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.checkReadAccessAndInstantiate(this.fetchTopicsByPropertyRange(propUri, from, to));
    }

    List<Association> getAssociationsByProperty(String propUri, Object propValue) {
        return this.checkReadAccessAndInstantiate(this.fetchAssociationsByProperty(propUri, propValue));
    }

    List<Association> getAssociationsByPropertyRange(String propUri, Number from, Number to) {
        return this.checkReadAccessAndInstantiate(this.fetchAssociationsByPropertyRange(propUri, from, to));
    }

    <O> O checkReadAccessAndInstantiate(DeepaMehtaObjectModelImpl model) {
        this.checkReadAccess(model);
        return (O)model.instantiate();
    }

    <O> List<O> checkReadAccessAndInstantiate(Iterable<? extends DeepaMehtaObjectModelImpl> models) {
        return this.instantiate(this.filterReadables(models));
    }

    private <M extends DeepaMehtaObjectModelImpl> Iterable<M> filterReadables(Iterable<M> models) {
        Iterator<M> i = models.iterator();
        while (i.hasNext()) {
            if (this.hasReadAccess((DeepaMehtaObjectModelImpl)i.next())) continue;
            i.remove();
        }
        return models;
    }

    boolean hasReadAccess(DeepaMehtaObjectModelImpl model) {
        try {
            this.checkReadAccess(model);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private void checkReadAccess(DeepaMehtaObjectModelImpl model) {
        this.em.fireEvent(model.getReadAccessEvent(), model.getId());
    }

    private void checkTopicReadAccess(long topicId) {
        this.em.fireEvent(CoreEvent.CHECK_TOPIC_READ_ACCESS, topicId);
    }

    private void checkAssociationReadAccess(long assocId) {
        this.em.fireEvent(CoreEvent.CHECK_ASSOCIATION_READ_ACCESS, assocId);
    }

    private void checkTopicWriteAccess(long topicId) {
        this.em.fireEvent(CoreEvent.CHECK_TOPIC_WRITE_ACCESS, topicId);
    }

    private void checkAssociationWriteAccess(long assocId) {
        this.em.fireEvent(CoreEvent.CHECK_ASSOCIATION_WRITE_ACCESS, assocId);
    }

    <O> List<O> instantiate(Iterable<? extends DeepaMehtaObjectModelImpl> models) {
        ArrayList<DeepaMehtaObject> objects = new ArrayList<DeepaMehtaObject>();
        for (DeepaMehtaObjectModelImpl deepaMehtaObjectModelImpl : models) {
            objects.add(deepaMehtaObjectModelImpl.instantiate());
        }
        return objects;
    }

    private List<String> getTopicTypeUris() {
        try {
            ArrayList<String> topicTypeUris = new ArrayList<String>();
            topicTypeUris.add("dm4.core.topic_type");
            topicTypeUris.add("dm4.core.assoc_type");
            topicTypeUris.add("dm4.core.meta_type");
            topicTypeUris.add("dm4.core.meta_meta_type");
            for (TopicModel topicModel : this.filterReadables(this.fetchTopics("type_uri", new SimpleValue("dm4.core.topic_type")))) {
                topicTypeUris.add(topicModel.getUri());
            }
            return topicTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of topic type URIs failed", e);
        }
    }

    private List<String> getAssociationTypeUris() {
        try {
            ArrayList<String> assocTypeUris = new ArrayList<String>();
            for (TopicModel topicModel : this.filterReadables(this.fetchTopics("type_uri", new SimpleValue("dm4.core.assoc_type")))) {
                assocTypeUris.add(topicModel.getUri());
            }
            return assocTypeUris;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching list of association type URIs failed", e);
        }
    }

    private void createTypeTopic(TypeModelImpl model, String uriPrefix) {
        TopicModelImpl typeTopic = this.mf.newTopicModel(model);
        this.createTopic(typeTopic, uriPrefix);
        model.id = typeTopic.id;
        model.uri = typeTopic.uri;
        this.typeStorage.storeType(model);
    }

    private String typeUri(long objectId) {
        return (String)this.fetchProperty(objectId, "type_uri");
    }

    private void bootstrapTypeCache() {
        TopicTypeModelImpl metaMetaType = this.mf.newTopicTypeModel("dm4.core.meta_meta_type", "Meta Meta Type", "dm4.core.text");
        metaMetaType.setTypeUri("dm4.core.meta_meta_meta_type");
        this.typeStorage.putInTypeCache(metaMetaType);
    }
}

