/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.AssociationDefinition;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.impl.ChildTopicsImpl;
import de.deepamehta.core.impl.ChildTopicsModelImpl;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.ModelFactoryImpl;
import de.deepamehta.core.impl.PersistenceLayer;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.RelatedTopicModel;
import de.deepamehta.core.model.SimpleValue;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;

abstract class DeepaMehtaObjectImpl
implements DeepaMehtaObject {
    DeepaMehtaObjectModelImpl model;
    PersistenceLayer pl;
    ModelFactoryImpl mf;

    DeepaMehtaObjectImpl(DeepaMehtaObjectModelImpl model, PersistenceLayer pl) {
        this.model = model;
        this.pl = pl;
        this.mf = pl.mf;
    }

    @Override
    public long getId() {
        return this.model.getId();
    }

    @Override
    public String getUri() {
        return this.model.getUri();
    }

    @Override
    public void setUri(String uri) {
        this.model.updateUri(uri);
    }

    @Override
    public String getTypeUri() {
        return this.model.getTypeUri();
    }

    @Override
    public void setTypeUri(String typeUri) {
        this.model.updateTypeUri(typeUri);
    }

    @Override
    public SimpleValue getSimpleValue() {
        return this.model.getSimpleValue();
    }

    @Override
    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(SimpleValue value) {
        this.model.updateSimpleValue(value);
    }

    @Override
    public ChildTopicsImpl getChildTopics() {
        return new ChildTopicsImpl(this.model.childTopics, this.model, this.pl);
    }

    @Override
    public void setChildTopics(ChildTopicsModel childTopics) {
        try {
            this.model._updateChildTopics((ChildTopicsModelImpl)childTopics);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the child topics failed (" + childTopics + ")", e);
        }
    }

    @Override
    public DeepaMehtaObject loadChildTopics() {
        this.model.loadChildTopics();
        return this;
    }

    @Override
    public DeepaMehtaObject loadChildTopics(String assocDefUri) {
        this.model.loadChildTopics(assocDefUri);
        return this;
    }

    @Override
    public DeepaMehtaObjectModelImpl getModel() {
        return this.model;
    }

    @Override
    public final void update(DeepaMehtaObjectModel newModel) {
        this.model.update((DeepaMehtaObjectModelImpl)newModel);
    }

    @Override
    public void updateChildTopic(RelatedTopicModel newChildTopic, AssociationDefinition assocDef) {
        this.model.updateChildTopics((RelatedTopicModelImpl)newChildTopic, null, assocDef.getModel());
    }

    @Override
    public void updateChildTopics(List<? extends RelatedTopicModel> newChildTopics, AssociationDefinition assocDef) {
        this.model.updateChildTopics(null, newChildTopics, assocDef.getModel());
    }

    @Override
    public final void delete() {
        this.model.delete();
    }

    @Override
    public RelatedTopic getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        RelatedTopicModelImpl topic = this.model.getRelatedTopic(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return topic != null ? (RelatedTopic)this.pl.checkReadAccessAndInstantiate(topic) : null;
    }

    @Override
    public List<RelatedTopic> getRelatedTopics(String assocTypeUri) {
        return this.getRelatedTopics(assocTypeUri, null, null, null);
    }

    @Override
    public List<RelatedTopic> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        List<RelatedTopicModelImpl> topics = this.model.getRelatedTopics(assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
        return this.pl.checkReadAccessAndInstantiate(topics);
    }

    @Override
    public Object getProperty(String propUri) {
        return this.pl.fetchProperty(this.getId(), propUri);
    }

    @Override
    public boolean hasProperty(String propUri) {
        return this.pl.hasProperty(this.getId(), propUri);
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.pl.getDatabaseVendorObject(this.getId());
    }

    @Override
    public JSONObject toJSON() {
        return this.model.toJSON();
    }

    public boolean equals(Object o) {
        return ((DeepaMehtaObjectImpl)o).model.equals(this.model);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public String toString() {
        return this.model.toString();
    }

    final String className() {
        return this.model.className();
    }
}

