/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.impl;

import de.deepamehta.core.impl.AssociationImpl;
import de.deepamehta.core.impl.CoreEvent;
import de.deepamehta.core.impl.DeepaMehtaObjectModelImpl;
import de.deepamehta.core.impl.RelatedTopicModelImpl;
import de.deepamehta.core.impl.RoleModelImpl;
import de.deepamehta.core.impl.TopicModelImpl;
import de.deepamehta.core.impl.TopicRoleModelImpl;
import de.deepamehta.core.impl.TypeModelImpl;
import de.deepamehta.core.model.AssociationModel;
import de.deepamehta.core.model.AssociationTypeModel;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.DeepaMehtaObjectModel;
import de.deepamehta.core.model.IndexMode;
import de.deepamehta.core.model.RoleModel;
import de.deepamehta.core.model.TopicRoleModel;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.Directive;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;

class AssociationModelImpl
extends DeepaMehtaObjectModelImpl
implements AssociationModel {
    private RoleModelImpl roleModel1;
    private RoleModelImpl roleModel2;

    AssociationModelImpl(DeepaMehtaObjectModelImpl object, RoleModelImpl roleModel1, RoleModelImpl roleModel2) {
        super(object);
        this.roleModel1 = roleModel1;
        this.roleModel2 = roleModel2;
    }

    AssociationModelImpl(AssociationModelImpl assoc) {
        super(assoc);
        this.roleModel1 = assoc.roleModel1;
        this.roleModel2 = assoc.roleModel2;
    }

    @Override
    public RoleModelImpl getRoleModel1() {
        return this.roleModel1;
    }

    @Override
    public RoleModelImpl getRoleModel2() {
        return this.roleModel2;
    }

    @Override
    public void setRoleModel1(RoleModel roleModel1) {
        this.roleModel1 = (RoleModelImpl)roleModel1;
    }

    @Override
    public void setRoleModel2(RoleModel roleModel2) {
        this.roleModel2 = (RoleModelImpl)roleModel2;
    }

    @Override
    public RoleModel getRoleModel(String roleTypeUri) {
        boolean rm1 = this.roleModel1.getRoleTypeUri().equals(roleTypeUri);
        boolean rm2 = this.roleModel2.getRoleTypeUri().equals(roleTypeUri);
        if (rm1 && rm2) {
            throw new RuntimeException("Ambiguous getRoleModel() call: both players occupy role \"" + roleTypeUri + "\" (" + this + ")");
        }
        return rm1 ? this.roleModel1 : (rm2 ? this.roleModel2 : null);
    }

    @Override
    public long getOtherPlayerId(long id) {
        long id1 = this.roleModel1.getPlayerId();
        long id2 = this.roleModel2.getPlayerId();
        if (id1 == id) {
            return id2;
        }
        if (id2 == id) {
            return id1;
        }
        throw new IllegalArgumentException("ID " + id + " doesn't refer to a player in " + this);
    }

    @Override
    public boolean hasSameRoleTypeUris() {
        return this.roleModel1.getRoleTypeUri().equals(this.roleModel2.getRoleTypeUri());
    }

    @Override
    public RoleModel createRoleModel(String roleTypeUri) {
        return this.mf.newAssociationRoleModel(this.id, roleTypeUri);
    }

    @Override
    public JSONObject toJSON() {
        try {
            return super.toJSON().put("role_1", (Object)this.roleModel1.toJSON()).put("role_2", (Object)this.roleModel2.toJSON());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }

    @Override
    public AssociationModel clone() {
        try {
            AssociationModel model = (AssociationModel)super.clone();
            model.setRoleModel1(this.roleModel1.clone());
            model.setRoleModel2(this.roleModel2.clone());
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning an AssociationModel failed", e);
        }
    }

    @Override
    public String toString() {
        return "association (" + super.toString() + ", " + this.roleModel1 + ", " + this.roleModel2 + ")";
    }

    @Override
    String className() {
        return "association";
    }

    @Override
    AssociationImpl instantiate() {
        return new AssociationImpl(this, this.pl);
    }

    @Override
    AssociationTypeModel getType() {
        return this.pl.typeStorage.getAssociationType(this.typeUri);
    }

    @Override
    List<AssociationModelImpl> getAssociations() {
        return this.pl.fetchAssociationAssociations(this.id);
    }

    @Override
    RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchAssociationRelatedTopic(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchAssociationRelatedTopics(this.id, assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        return this.pl.fetchAssociationRelatedTopics(this.id, assocTypeUris, myRoleTypeUri, othersRoleTypeUri, othersTopicTypeUri);
    }

    @Override
    void storeUri() {
        this.pl.storeAssociationUri(this.id, this.uri);
    }

    @Override
    void storeTypeUri() {
        this.reassignInstantiation();
        this.pl.storeAssociationTypeUri(this.id, this.typeUri);
    }

    @Override
    void storeSimpleValue() {
        AssociationTypeModel type = this.getType();
        this.pl.storeAssociationValue(this.id, this.value, type.getIndexModes(), type.getUri(), this.getIndexValue());
    }

    @Override
    void indexSimpleValue(IndexMode indexMode) {
        this.pl.indexAssociationValue(this.id, indexMode, this.typeUri, this.getIndexValue());
    }

    @Override
    void updateChildTopics(ChildTopicsModel childTopics) {
        this.update(this.mf.newAssociationModel(childTopics));
    }

    @Override
    void _delete() {
        this.pl._deleteAssociation(this.id);
    }

    @Override
    DeepaMehtaEvent getReadAccessEvent() {
        return CoreEvent.CHECK_ASSOCIATION_READ_ACCESS;
    }

    @Override
    DeepaMehtaEvent getPreUpdateEvent() {
        return CoreEvent.PRE_UPDATE_ASSOCIATION;
    }

    @Override
    DeepaMehtaEvent getPostUpdateEvent() {
        return CoreEvent.POST_UPDATE_ASSOCIATION;
    }

    @Override
    DeepaMehtaEvent getPreDeleteEvent() {
        return CoreEvent.PRE_DELETE_ASSOCIATION;
    }

    @Override
    DeepaMehtaEvent getPostDeleteEvent() {
        return CoreEvent.POST_DELETE_ASSOCIATION;
    }

    @Override
    Directive getUpdateDirective() {
        return Directive.UPDATE_ASSOCIATION;
    }

    @Override
    Directive getDeleteDirective() {
        return Directive.DELETE_ASSOCIATION;
    }

    @Override
    void preCreate() {
        this.duplicateCheck();
    }

    @Override
    void postUpdate(DeepaMehtaObjectModel newModel, DeepaMehtaObjectModel oldModel) {
        this.updateRoles((AssociationModel)newModel);
        this.duplicateCheck();
        if (this.isAssocDef(this)) {
            if (this.isAssocDef((AssociationModel)oldModel)) {
                this.updateAssocDef();
            } else {
                this.createAssocDef();
            }
        } else if (this.isAssocDef((AssociationModel)oldModel)) {
            this.removeAssocDef();
        }
    }

    @Override
    void preDelete() {
        if (this.isAssocDef(this)) {
            this.removeAssocDef();
        }
    }

    TopicModelImpl getTopic(String roleTypeUri) {
        RoleModel role = this.getRoleModel(roleTypeUri);
        return role instanceof TopicRoleModel ? ((TopicRoleModelImpl)role).getPlayer() : null;
    }

    TopicModelImpl getTopicByType(String topicTypeUri) {
        TopicModelImpl topic1 = this.filterTopic(this.roleModel1, topicTypeUri);
        TopicModelImpl topic2 = this.filterTopic(this.roleModel2, topicTypeUri);
        if (topic1 != null && topic2 != null) {
            throw new RuntimeException("Ambiguous getTopicByType() call: both topics are of type \"" + topicTypeUri + "\" (" + this + ")");
        }
        return topic1 != null ? topic1 : (topic2 != null ? topic2 : null);
    }

    void updateRoleTypeUri(RoleModelImpl role, String roleTypeUri) {
        role.setRoleTypeUri(roleTypeUri);
        this.pl.storeRoleTypeUri(this.id, role.playerId, role.roleTypeUri);
    }

    private void duplicateCheck() {
        if (!(this.roleModel1 instanceof TopicRoleModel) || ((TopicRoleModel)((Object)this.roleModel1)).topicIdentifiedByUri() || !(this.roleModel2 instanceof TopicRoleModel) || ((TopicRoleModel)((Object)this.roleModel2)).topicIdentifiedByUri()) {
            return;
        }
        for (AssociationModelImpl assoc : this.pl._getAssociations(this.typeUri, this.roleModel1.playerId, this.roleModel2.playerId, this.roleModel1.roleTypeUri, this.roleModel2.roleTypeUri)) {
            if (assoc.id == this.id) continue;
            throw new RuntimeException("Duplicate: such an association exists already (ID=" + assoc.id + ", typeUri=\"" + this.typeUri + "\")");
        }
    }

    private void updateRoles(AssociationModel newModel) {
        this.updateRole(newModel.getRoleModel1(), 1);
        this.updateRole(newModel.getRoleModel2(), 2);
    }

    private void updateRole(RoleModel newModel, int nr) {
        if (newModel != null) {
            RoleModelImpl role = this.getRole(newModel);
            String newRoleTypeUri = newModel.getRoleTypeUri();
            String roleTypeUri = role.getRoleTypeUri();
            if (!roleTypeUri.equals(newRoleTypeUri)) {
                this.logger.info("### Changing role type " + nr + " from \"" + roleTypeUri + "\" -> \"" + newRoleTypeUri + "\"");
                this.updateRoleTypeUri(role, newRoleTypeUri);
            }
        }
    }

    private RoleModelImpl getRole(RoleModel roleModel) {
        if (this.roleModel1.refsSameObject(roleModel)) {
            return this.roleModel1;
        }
        if (this.roleModel2.refsSameObject(roleModel)) {
            return this.roleModel2;
        }
        throw new RuntimeException("Role is not part of association (role=" + roleModel + ", association=" + this);
    }

    private TopicModelImpl filterTopic(RoleModelImpl role, String topicTypeUri) {
        TopicModelImpl topic;
        if (role instanceof TopicRoleModel && (topic = ((TopicRoleModelImpl)role).getPlayer()).getTypeUri().equals(topicTypeUri)) {
            return topic;
        }
        return null;
    }

    private void reassignInstantiation() {
        this.fetchInstantiation().delete();
        this.pl.createAssociationInstantiation(this.id, this.typeUri);
    }

    private AssociationModelImpl fetchInstantiation() {
        RelatedTopicModelImpl assocType = this.getRelatedTopic("dm4.core.instantiation", "dm4.core.instance", "dm4.core.type", "dm4.core.assoc_type");
        if (assocType == null) {
            throw new RuntimeException("Association " + this.id + " is not associated to an association type");
        }
        return assocType.getRelatingAssociation();
    }

    private void createAssocDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Adding association definition " + this.id + " to type \"" + parentType.getUri() + "\"");
        parentType._addAssocDef(this);
    }

    private void updateAssocDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Updating association definition " + this.id + " of type \"" + parentType.getUri() + "\"");
        parentType._updateAssocDef(this);
    }

    private void removeAssocDef() {
        TypeModelImpl parentType = this.fetchParentType();
        this.logger.info("##### Removing association definition " + this.id + " from type \"" + parentType.getUri() + "\"");
        parentType._removeAssocDefFromMemoryAndRebuildSequence(this);
    }

    private boolean isAssocDef(AssociationModel assoc) {
        String typeUri = assoc.getTypeUri();
        if (!typeUri.equals("dm4.core.aggregation_def") && !typeUri.equals("dm4.core.composition_def")) {
            return false;
        }
        if (assoc.hasSameRoleTypeUris()) {
            return false;
        }
        return assoc.getRoleModel("dm4.core.parent_type") != null && assoc.getRoleModel("dm4.core.child_type") != null;
    }

    private TypeModelImpl fetchParentType() {
        return this.pl.typeStorage.fetchParentType(this);
    }
}

