/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.service.accesscontrol;

import com.sun.jersey.core.util.Base64;
import de.deepamehta.core.util.JavaUtils;
import org.codehaus.jettison.json.JSONObject;

public class Credentials {
    private static final String ENCODED_PASSWORD_PREFIX = "-SHA256-";
    public String username;
    public String password;

    public Credentials(String username, String password) {
        this.username = username;
        this.password = this.encodePassword(password);
    }

    public Credentials(JSONObject cred) {
        try {
            this.username = cred.getString("username");
            this.password = cred.getString("password");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal JSON argument " + cred, e);
        }
    }

    public Credentials(String authHeader) {
        authHeader = authHeader.substring("Basic ".length());
        String[] values = new String(Base64.base64Decode((String)authHeader)).split(":");
        this.username = values.length > 0 ? values[0] : "";
        this.password = this.encodePassword(values.length > 1 ? values[1] : "");
    }

    public String toString() {
        return "username=\"" + this.username + "\", password=\"" + this.password + "\"";
    }

    private String encodePassword(String password) {
        return ENCODED_PASSWORD_PREFIX + JavaUtils.encodeSHA256(password);
    }
}

