/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.core.service;

import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.JSONEnabled;
import de.deepamehta.core.util.DeepaMehtaUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;

public class ResultList<T extends JSONEnabled>
implements Iterable<T>,
JSONEnabled {
    private int totalCount;
    private List<T> items;

    public ResultList() {
        this.totalCount = 0;
        this.items = new ArrayList<T>();
    }

    public ResultList(int totalCount, List<T> items) {
        this.totalCount = totalCount;
        this.items = items;
    }

    public T get(int index) {
        return (T)((JSONEnabled)this.items.get(index));
    }

    public int getSize() {
        return this.items.size();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void add(T item) {
        ++this.totalCount;
        this.items.add(item);
    }

    public void addAll(ResultList<T> result) {
        this.totalCount += result.getTotalCount();
        this.items.addAll(result.getItems());
    }

    public ResultList<T> loadChildTopics() {
        for (JSONEnabled item : this) {
            ((DeepaMehtaObject)item).loadChildTopics();
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            o.put("total_count", this.totalCount);
            o.put("items", (Object)DeepaMehtaUtils.objectsToJSON(this.items));
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed (" + this + ")", e);
        }
    }
}

